/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm2.exchange;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.SM2KeyExchange;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import org.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.TestRandomBigInteger;

public class SM2Coder_Ag {
    static BigInteger SM2_ECC_P = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DE457283915C45517D722EDB8B08F1DFC3", 16);
    static BigInteger SM2_ECC_A = new BigInteger("787968B4FA32C3FD2417842E73BBFEFF2F3C848B6831D7E0EC65228B3937E498", 16);
    static BigInteger SM2_ECC_B = new BigInteger("63E4C6D3B23B0C849CF84241484BFE48F61D59A5B16BA06E6E12D1DA27C5249A", 16);
    static BigInteger SM2_ECC_N = new BigInteger("8542D69E4C044F18E8B92435BF6FF7DD297720630485628D5AE74EE7C32E79B7", 16);
    static BigInteger SM2_ECC_H = ECConstants.ONE;
    static BigInteger SM2_ECC_GX = new BigInteger("421DEBD61B62EAB6746434EBC3CC315E32220B3BADD50BDC4C4E6C147FEDD43D", 16);
    static BigInteger SM2_ECC_GY = new BigInteger("0680512BCBB42C07D47349D2153B70C4E5D7FDFCBFA36EA1A85841B9E46E09A2", 16);
    private static ECDomainParameters domainParams = null;

    private static void getcurve() {
        if (domainParams != null) {
            return;
        }
        ECCurve.Fp curve = new ECCurve.Fp(SM2_ECC_P, SM2_ECC_A, SM2_ECC_B, SM2_ECC_N, SM2_ECC_H);
        ECPoint g = curve.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        domainParams = new ECDomainParameters((ECCurve)curve, g, SM2_ECC_N);
    }

    public static Map<String, Object> initKeyA() throws Exception {
        SM2Coder_Ag.getcurve();
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters aKeyGenParams = new ECKeyGenerationParameters(domainParams, (SecureRandom)new TestRandomBigInteger("7FCBA2EF9AE0AB902BC3BDE3FF915D44BA4CC78F88E2F8E7F8996D3B8CCEEDEE", 16));
        keyPairGenerator.init((KeyGenerationParameters)aKeyGenParams);
        AsymmetricCipherKeyPair aKp = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters aPub = (ECPublicKeyParameters)aKp.getPublic();
        ECPrivateKeyParameters aPriv = (ECPrivateKeyParameters)aKp.getPrivate();
        SecureRandom random = new SecureRandom();
        ECKeyGenerationParameters aeKeyGenParams = new ECKeyGenerationParameters(domainParams, random);
        keyPairGenerator.init((KeyGenerationParameters)aeKeyGenParams);
        AsymmetricCipherKeyPair aeKp = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters aePub = (ECPublicKeyParameters)aeKp.getPublic();
        ECPrivateKeyParameters aePriv = (ECPrivateKeyParameters)aeKp.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(4);
        keyMap.put("aPub", aPub);
        keyMap.put("aPriv", aPriv);
        keyMap.put("aePub", aePub);
        keyMap.put("aePriv", aePriv);
        return keyMap;
    }

    public static Map<String, Object> initKeyB() throws Exception {
        ECKeyGenerationParameters bKeyGenParams = new ECKeyGenerationParameters(domainParams, (SecureRandom)new TestRandomBigInteger("5E35D7D3F3C54DBAC72E61819E730B019A84208CA3A35E4C2E353DFCCB2A3B53", 16));
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)bKeyGenParams);
        AsymmetricCipherKeyPair bKp = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters bPub = (ECPublicKeyParameters)bKp.getPublic();
        ECPrivateKeyParameters bPriv = (ECPrivateKeyParameters)bKp.getPrivate();
        SecureRandom random = new SecureRandom();
        ECKeyGenerationParameters beKeyGenParams = new ECKeyGenerationParameters(domainParams, random);
        keyPairGenerator.init((KeyGenerationParameters)beKeyGenParams);
        AsymmetricCipherKeyPair beKp = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters bePub = (ECPublicKeyParameters)beKp.getPublic();
        ECPrivateKeyParameters bePriv = (ECPrivateKeyParameters)beKp.getPrivate();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("bPub", bPub);
        map.put("bPriv", bPriv);
        map.put("bePub", bePub);
        map.put("bePriv", bePriv);
        return map;
    }

    public static byte[] KeyExchangeA(ECPrivateKeyParameters aPriv, ECPrivateKeyParameters aePriv, ECPublicKeyParameters bPub, ECPublicKeyParameters bePub) throws Exception {
        SM2KeyExchange exch = new SM2KeyExchange();
        exch.init((CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePrivateParameters(true, aPriv, aePriv), Strings.toByteArray((String)"ALICE123@YAHOO.COM")));
        byte[] k1 = exch.calculateKey(128, (CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePublicParameters(bPub, bePub), Strings.toByteArray((String)"BILL456@YAHOO.COM")));
        return k1;
    }

    public static byte[] KeyExchangeB(ECPrivateKeyParameters bPriv, ECPrivateKeyParameters bePriv, ECPublicKeyParameters aPub, ECPublicKeyParameters aePub) throws Exception {
        SM2KeyExchange exch = new SM2KeyExchange();
        exch.init((CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePrivateParameters(false, bPriv, bePriv), Strings.toByteArray((String)"BILL456@YAHOO.COM")));
        byte[] k2 = exch.calculateKey(128, (CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePublicParameters(aPub, aePub), Strings.toByteArray((String)"ALICE123@YAHOO.COM")));
        return k2;
    }

    public static ECPrivateKeyParameters getPrivateKey(String str, Map<String, Object> keyMap) throws Exception {
        ECPrivateKeyParameters key = (ECPrivateKeyParameters)keyMap.get(str);
        return key;
    }

    public static ECPublicKeyParameters getPublicKey(String str, Map<String, Object> keyMap) throws Exception {
        ECPublicKeyParameters key = (ECPublicKeyParameters)keyMap.get(str);
        return key;
    }
}

