/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm4;

import com.security.gm.Utils;
import com.security.gm.sm4.SM4;
import com.security.gm.sm4.SM4_Context;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;

public class SM4Utils {
    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : Utils.hexStringToBytes(this.secretKey);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            return Utils.byteToHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            byte[] encrypted = Utils.hexToByte(cipherText);
            cipherText = Base64.toBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes("UTF-8");
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decode((String)cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes("UTF-8");
                ivBytes = this.iv.getBytes("UTF-8");
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            return Utils.byteToHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            byte[] encrypted = Utils.hexToByte(cipherText);
            cipherText = Base64.toBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes("UTF-8");
                ivBytes = this.iv.getBytes("UTF-8");
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decode((String)cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void test(SM4Utils sm4, String str) {
        String cipherText = sm4.encryptData_ECB(str);
        String plainText2 = sm4.decryptData_ECB(cipherText);
        System.out.println(plainText2);
    }

    public static void main(String[] args) throws IOException {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = "64EC7C763AB7BF64E2D75FF83A319918";
        sm4.hexString = true;
        String plainText = "I Love You Every Day \u518d\u770b\u54c8\u65f6\u523b\u90fd\u4f1a\u6982\u51b5\u6211\u6211\u8ba9\u6c34\u7535\u8d39\u53ef\u56de\u6536\u7684\uffe5#\u2026\u2026%%&*\uff08*&\u2026\u2026*\uff08&\u2026\u2026";
        System.out.println("CBC\u6a21\u5f0f\u52a0\u5bc6");
        sm4.iv = "31313131313131313131313131313131";
        String cipherText2 = sm4.encryptData_CBC(plainText);
        System.out.println("\u52a0\u5bc6\u5bc6\u6587: " + cipherText2);
        System.out.println("");
        String plainText3 = sm4.decryptData_CBC(cipherText2);
        System.out.println("\u89e3\u5bc6\u660e\u6587: " + plainText3);
    }
}

