/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm4base64;

import com.security.gm.sm4base64.SM4_Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class SM4 {
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 0;
    public static final byte[] SboxTable;
    public static final int[] FK;
    public static final int[] CK;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -42;
        byArray[1] = -112;
        byArray[2] = -23;
        byArray[3] = -2;
        byArray[4] = -52;
        byArray[5] = -31;
        byArray[6] = 61;
        byArray[7] = -73;
        byArray[8] = 22;
        byArray[9] = -74;
        byArray[10] = 20;
        byArray[11] = -62;
        byArray[12] = 40;
        byArray[13] = -5;
        byArray[14] = 44;
        byArray[15] = 5;
        byArray[16] = 43;
        byArray[17] = 103;
        byArray[18] = -102;
        byArray[19] = 118;
        byArray[20] = 42;
        byArray[21] = -66;
        byArray[22] = 4;
        byArray[23] = -61;
        byArray[24] = -86;
        byArray[25] = 68;
        byArray[26] = 19;
        byArray[27] = 38;
        byArray[28] = 73;
        byArray[29] = -122;
        byArray[30] = 6;
        byArray[31] = -103;
        byArray[32] = -100;
        byArray[33] = 66;
        byArray[34] = 80;
        byArray[35] = -12;
        byArray[36] = -111;
        byArray[37] = -17;
        byArray[38] = -104;
        byArray[39] = 122;
        byArray[40] = 51;
        byArray[41] = 84;
        byArray[42] = 11;
        byArray[43] = 67;
        byArray[44] = -19;
        byArray[45] = -49;
        byArray[46] = -84;
        byArray[47] = 98;
        byArray[48] = -28;
        byArray[49] = -77;
        byArray[50] = 28;
        byArray[51] = -87;
        byArray[52] = -55;
        byArray[53] = 8;
        byArray[54] = -24;
        byArray[55] = -107;
        byArray[56] = -128;
        byArray[57] = -33;
        byArray[58] = -108;
        byArray[59] = -6;
        byArray[60] = 117;
        byArray[61] = -113;
        byArray[62] = 63;
        byArray[63] = -90;
        byArray[64] = 71;
        byArray[65] = 7;
        byArray[66] = -89;
        byArray[67] = -4;
        byArray[68] = -13;
        byArray[69] = 115;
        byArray[70] = 23;
        byArray[71] = -70;
        byArray[72] = -125;
        byArray[73] = 89;
        byArray[74] = 60;
        byArray[75] = 25;
        byArray[76] = -26;
        byArray[77] = -123;
        byArray[78] = 79;
        byArray[79] = -88;
        byArray[80] = 104;
        byArray[81] = 107;
        byArray[82] = -127;
        byArray[83] = -78;
        byArray[84] = 113;
        byArray[85] = 100;
        byArray[86] = -38;
        byArray[87] = -117;
        byArray[88] = -8;
        byArray[89] = -21;
        byArray[90] = 15;
        byArray[91] = 75;
        byArray[92] = 112;
        byArray[93] = 86;
        byArray[94] = -99;
        byArray[95] = 53;
        byArray[96] = 30;
        byArray[97] = 36;
        byArray[98] = 14;
        byArray[99] = 94;
        byArray[100] = 99;
        byArray[101] = 88;
        byArray[102] = -47;
        byArray[103] = -94;
        byArray[104] = 37;
        byArray[105] = 34;
        byArray[106] = 124;
        byArray[107] = 59;
        byArray[108] = 1;
        byArray[109] = 33;
        byArray[110] = 120;
        byArray[111] = -121;
        byArray[112] = -44;
        byArray[114] = 70;
        byArray[115] = 87;
        byArray[116] = -97;
        byArray[117] = -45;
        byArray[118] = 39;
        byArray[119] = 82;
        byArray[120] = 76;
        byArray[121] = 54;
        byArray[122] = 2;
        byArray[123] = -25;
        byArray[124] = -96;
        byArray[125] = -60;
        byArray[126] = -56;
        byArray[127] = -98;
        byArray[128] = -22;
        byArray[129] = -65;
        byArray[130] = -118;
        byArray[131] = -46;
        byArray[132] = 64;
        byArray[133] = -57;
        byArray[134] = 56;
        byArray[135] = -75;
        byArray[136] = -93;
        byArray[137] = -9;
        byArray[138] = -14;
        byArray[139] = -50;
        byArray[140] = -7;
        byArray[141] = 97;
        byArray[142] = 21;
        byArray[143] = -95;
        byArray[144] = -32;
        byArray[145] = -82;
        byArray[146] = 93;
        byArray[147] = -92;
        byArray[148] = -101;
        byArray[149] = 52;
        byArray[150] = 26;
        byArray[151] = 85;
        byArray[152] = -83;
        byArray[153] = -109;
        byArray[154] = 50;
        byArray[155] = 48;
        byArray[156] = -11;
        byArray[157] = -116;
        byArray[158] = -79;
        byArray[159] = -29;
        byArray[160] = 29;
        byArray[161] = -10;
        byArray[162] = -30;
        byArray[163] = 46;
        byArray[164] = -126;
        byArray[165] = 102;
        byArray[166] = -54;
        byArray[167] = 96;
        byArray[168] = -64;
        byArray[169] = 41;
        byArray[170] = 35;
        byArray[171] = -85;
        byArray[172] = 13;
        byArray[173] = 83;
        byArray[174] = 78;
        byArray[175] = 111;
        byArray[176] = -43;
        byArray[177] = -37;
        byArray[178] = 55;
        byArray[179] = 69;
        byArray[180] = -34;
        byArray[181] = -3;
        byArray[182] = -114;
        byArray[183] = 47;
        byArray[184] = 3;
        byArray[185] = -1;
        byArray[186] = 106;
        byArray[187] = 114;
        byArray[188] = 109;
        byArray[189] = 108;
        byArray[190] = 91;
        byArray[191] = 81;
        byArray[192] = -115;
        byArray[193] = 27;
        byArray[194] = -81;
        byArray[195] = -110;
        byArray[196] = -69;
        byArray[197] = -35;
        byArray[198] = -68;
        byArray[199] = 127;
        byArray[200] = 17;
        byArray[201] = -39;
        byArray[202] = 92;
        byArray[203] = 65;
        byArray[204] = 31;
        byArray[205] = 16;
        byArray[206] = 90;
        byArray[207] = -40;
        byArray[208] = 10;
        byArray[209] = -63;
        byArray[210] = 49;
        byArray[211] = -120;
        byArray[212] = -91;
        byArray[213] = -51;
        byArray[214] = 123;
        byArray[215] = -67;
        byArray[216] = 45;
        byArray[217] = 116;
        byArray[218] = -48;
        byArray[219] = 18;
        byArray[220] = -72;
        byArray[221] = -27;
        byArray[222] = -76;
        byArray[223] = -80;
        byArray[224] = -119;
        byArray[225] = 105;
        byArray[226] = -105;
        byArray[227] = 74;
        byArray[228] = 12;
        byArray[229] = -106;
        byArray[230] = 119;
        byArray[231] = 126;
        byArray[232] = 101;
        byArray[233] = -71;
        byArray[234] = -15;
        byArray[235] = 9;
        byArray[236] = -59;
        byArray[237] = 110;
        byArray[238] = -58;
        byArray[239] = -124;
        byArray[240] = 24;
        byArray[241] = -16;
        byArray[242] = 125;
        byArray[243] = -20;
        byArray[244] = 58;
        byArray[245] = -36;
        byArray[246] = 77;
        byArray[247] = 32;
        byArray[248] = 121;
        byArray[249] = -18;
        byArray[250] = 95;
        byArray[251] = 62;
        byArray[252] = -41;
        byArray[253] = -53;
        byArray[254] = 57;
        byArray[255] = 72;
        SboxTable = byArray;
        FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
        CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    }

    private long GET_ULONG_BE(byte[] b, int i) {
        long n = (long)(b[i] & 0xFF) << 24 | (long)((b[i + 1] & 0xFF) << 16) | (long)((b[i + 2] & 0xFF) << 8) | (long)(b[i + 3] & 0xFF) & 0xFFFFFFFFL;
        return n;
    }

    private void PUT_ULONG_BE(long n, byte[] b, int i) {
        b[i] = (byte)(0xFFL & n >> 24);
        b[i + 1] = (byte)(0xFFL & n >> 16);
        b[i + 2] = (byte)(0xFFL & n >> 8);
        b[i + 3] = (byte)(0xFFL & n);
    }

    private long SHL(long x, int n) {
        return (x & 0xFFFFFFFFFFFFFFFFL) << n;
    }

    private long ROTL(long x, int n) {
        return this.SHL(x, n) | x >> 32 - n;
    }

    private void SWAP(long[] sk, int i) {
        long t = sk[i];
        sk[i] = sk[31 - i];
        sk[31 - i] = t;
    }

    private byte sm4Sbox(byte inch) {
        int i = inch & 0xFF;
        byte retVal = SboxTable[i];
        return retVal;
    }

    private long sm4Lt(long ka) {
        long bb = 0L;
        long c = 0L;
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        this.PUT_ULONG_BE(ka, a, 0);
        b[0] = this.sm4Sbox(a[0]);
        b[1] = this.sm4Sbox(a[1]);
        b[2] = this.sm4Sbox(a[2]);
        b[3] = this.sm4Sbox(a[3]);
        bb = this.GET_ULONG_BE(b, 0);
        c = bb ^ this.ROTL(bb, 2) ^ this.ROTL(bb, 10) ^ this.ROTL(bb, 18) ^ this.ROTL(bb, 24);
        return c;
    }

    private long sm4F(long x0, long x1, long x2, long x3, long rk) {
        return x0 ^ this.sm4Lt(x1 ^ x2 ^ x3 ^ rk);
    }

    private long sm4CalciRK(long ka) {
        long bb = 0L;
        long rk = 0L;
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        this.PUT_ULONG_BE(ka, a, 0);
        b[0] = this.sm4Sbox(a[0]);
        b[1] = this.sm4Sbox(a[1]);
        b[2] = this.sm4Sbox(a[2]);
        b[3] = this.sm4Sbox(a[3]);
        bb = this.GET_ULONG_BE(b, 0);
        rk = bb ^ this.ROTL(bb, 13) ^ this.ROTL(bb, 23);
        return rk;
    }

    private void sm4_setkey(long[] SK, byte[] key) {
        long[] MK = new long[4];
        long[] k = new long[36];
        int i = 0;
        MK[0] = this.GET_ULONG_BE(key, 0);
        MK[1] = this.GET_ULONG_BE(key, 4);
        MK[2] = this.GET_ULONG_BE(key, 8);
        MK[3] = this.GET_ULONG_BE(key, 12);
        k[0] = MK[0] ^ (long)FK[0];
        k[1] = MK[1] ^ (long)FK[1];
        k[2] = MK[2] ^ (long)FK[2];
        k[3] = MK[3] ^ (long)FK[3];
        while (i < 32) {
            k[i + 4] = k[i] ^ this.sm4CalciRK(k[i + 1] ^ k[i + 2] ^ k[i + 3] ^ (long)CK[i]);
            SK[i] = k[i + 4];
            ++i;
        }
    }

    private void sm4_one_round(long[] sk, byte[] input, byte[] output) {
        int i = 0;
        long[] ulbuf = new long[36];
        ulbuf[0] = this.GET_ULONG_BE(input, 0);
        ulbuf[1] = this.GET_ULONG_BE(input, 4);
        ulbuf[2] = this.GET_ULONG_BE(input, 8);
        ulbuf[3] = this.GET_ULONG_BE(input, 12);
        while (i < 32) {
            ulbuf[i + 4] = this.sm4F(ulbuf[i], ulbuf[i + 1], ulbuf[i + 2], ulbuf[i + 3], sk[i]);
            ++i;
        }
        this.PUT_ULONG_BE(ulbuf[35], output, 0);
        this.PUT_ULONG_BE(ulbuf[34], output, 4);
        this.PUT_ULONG_BE(ulbuf[33], output, 8);
        this.PUT_ULONG_BE(ulbuf[32], output, 12);
    }

    private byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }
        byte[] ret = null;
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            int i = 0;
            while (i < p) {
                ret[input.length + i] = (byte)p;
                ++i;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    public void sm4_setkey_enc(SM4_Context ctx, byte[] key) throws Exception {
        if (ctx == null) {
            throw new Exception("ctx is null!");
        }
        if (key == null || key.length != 16) {
            throw new Exception("key error!");
        }
        ctx.mode = 1;
        this.sm4_setkey(ctx.sk, key);
    }

    public void sm4_setkey_dec(SM4_Context ctx, byte[] key) throws Exception {
        if (ctx == null) {
            throw new Exception("ctx is null!");
        }
        if (key == null || key.length != 16) {
            throw new Exception("key error!");
        }
        int i = 0;
        ctx.mode = 0;
        this.sm4_setkey(ctx.sk, key);
        i = 0;
        while (i < 16) {
            this.SWAP(ctx.sk, i);
            ++i;
        }
    }

    public byte[] sm4_crypt_ecb(SM4_Context ctx, byte[] input) throws Exception {
        if (input == null) {
            throw new Exception("input is null!");
        }
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        int length = input.length;
        ByteArrayInputStream bins = new ByteArrayInputStream(input);
        ByteArrayOutputStream bous = new ByteArrayOutputStream();
        while (length > 0) {
            byte[] in = new byte[16];
            byte[] out = new byte[16];
            bins.read(in);
            this.sm4_one_round(ctx.sk, in, out);
            bous.write(out);
            length -= 16;
        }
        byte[] output = bous.toByteArray();
        if (ctx.isPadding && ctx.mode == 0) {
            output = this.padding(output, 0);
        }
        bins.close();
        bous.close();
        return output;
    }

    public byte[] sm4_crypt_cbc(SM4_Context ctx, byte[] iv, byte[] input) throws Exception {
        if (iv == null || iv.length != 16) {
            throw new Exception("iv error!");
        }
        if (input == null) {
            throw new Exception("input is null!");
        }
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        int i = 0;
        int length = input.length;
        ByteArrayInputStream bins = new ByteArrayInputStream(input);
        ByteArrayOutputStream bous = new ByteArrayOutputStream();
        if (ctx.mode == 1) {
            while (length > 0) {
                byte[] in = new byte[16];
                byte[] out = new byte[16];
                byte[] out1 = new byte[16];
                bins.read(in);
                i = 0;
                while (i < 16) {
                    out[i] = (byte)(in[i] ^ iv[i]);
                    ++i;
                }
                this.sm4_one_round(ctx.sk, out, out1);
                System.arraycopy(out1, 0, iv, 0, 16);
                bous.write(out1);
                length -= 16;
            }
        } else {
            byte[] temp = new byte[16];
            while (length > 0) {
                byte[] in = new byte[16];
                byte[] out = new byte[16];
                byte[] out1 = new byte[16];
                bins.read(in);
                System.arraycopy(in, 0, temp, 0, 16);
                this.sm4_one_round(ctx.sk, in, out);
                i = 0;
                while (i < 16) {
                    out1[i] = (byte)(out[i] ^ iv[i]);
                    ++i;
                }
                System.arraycopy(temp, 0, iv, 0, 16);
                bous.write(out1);
                length -= 16;
            }
        }
        byte[] output = bous.toByteArray();
        if (ctx.isPadding && ctx.mode == 0) {
            output = this.padding(output, 0);
        }
        bins.close();
        bous.close();
        return output;
    }
}

