/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm4base64;

import com.security.gm.Utils;
import com.security.gm.sm4base64.SM4;
import com.security.gm.sm4base64.SM4_Context;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SM4Utils {
    private String secretKey = "";
    private String iv = "";
    private boolean hexString = false;

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes("UTF-8");
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes("UTF-8");
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes("UTF-8");
                ivBytes = this.iv.getBytes("UTF-8");
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes("UTF-8");
                ivBytes = this.iv.getBytes("UTF-8");
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String plainText = "I Love You Every Day \u518d\u770b\u54c8\u65f6\u523b\u90fd\u4f1a\u6982\u51b5\u6211\u6211\u8ba9\u6c34\u7535\u8d39\u53ef\u56de\u6536\u7684\uffe5#\u2026\u2026%%&*\uff08*&\u2026\u2026*\uff08&\u2026\u2026";
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = "JeFU9wHFOMfs2Y8a";
        sm4.hexString = false;
        System.out.println("ECB\u6a21\u5f0f");
        String cipherText = sm4.encryptData_ECB(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println("");
        plainText = sm4.decryptData_ECB(cipherText);
        System.out.println("\u660e\u6587: " + plainText);
        System.out.println("");
        System.out.println("CBC\u6a21\u5f0f");
        sm4.iv = "UISwD9fW6cFh9SNS";
        cipherText = sm4.encryptData_CBC(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println("");
        plainText = sm4.decryptData_CBC(cipherText);
        System.out.println("\u660e\u6587: " + plainText);
    }
}

