/*
 * Decompiled with CFR 0.152.
 */
package global.hh.openapi.sdk.utils;

import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.InvalidSignatureException;
import global.hh.openapi.sdk.utils.JsonUtils;
import global.hh.openapi.sdk.utils.StringUtils;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

public class SignatureUtils {
    public static String generateSignature(Map<String, Object> publicParams, Map<String, Object> businessParams, String secretKey) throws BaseException {
        TreeMap allMap = new TreeMap();
        if (businessParams != null) {
            for (Map.Entry<String, Object> entry : businessParams.entrySet()) {
                if (entry.getValue() == null || StringUtils.isEmpty(entry.getValue().toString())) continue;
                allMap.put(entry.getKey(), entry.getValue());
            }
        }
        allMap.putAll(publicParams);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : allMap.entrySet()) {
            string.append((String)entry.getKey()).append(JsonUtils.toJson(entry.getValue()));
        }
        String original = String.format("%s%s%s", secretKey, string.toString(), secretKey);
        String string2 = (String)publicParams.get("signMethod");
        String signature = "";
        if ("MD5".equals(string2)) {
            signature = SignatureUtils.md5Encode(original);
        } else if ("SHA256".equals(string2)) {
            signature = SignatureUtils.sha256Encode(original);
        } else {
            throw new InvalidSignatureException("\u6682\u65f6\u4e0d\u652f\u6301" + string2 + "\u7b97\u6cd5");
        }
        return signature.toUpperCase();
    }

    private static String md5Encode(String inStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] byteArray = inStr.getBytes("UTF-8");
            byte[] md5Bytes = md5.digest(byteArray);
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
    }

    private static String sha256Encode(String inStr) {
        try {
            MessageDigest sha = null;
            try {
                sha = MessageDigest.getInstance("SHA-256");
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
                return "";
            }
            byte[] byteArray = inStr.getBytes("UTF-8");
            byte[] md5Bytes = sha.digest(byteArray);
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

