/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArrayMathFunction;
import java.util.List;

public class AvgFunction
extends ArrayMathFunction {
    public AvgFunction() {
        super(ArgumentConstraints.typeOf(JmesPathType.NUMBER));
    }

    @Override
    protected <T> T performMathOperation(Adapter<T> runtime, List<T> values) {
        if (values.isEmpty()) {
            return runtime.createNull();
        }
        double sum = 0.0;
        int count = 0;
        for (T n : values) {
            sum += runtime.toNumber(n).doubleValue();
            ++count;
        }
        return runtime.createNumber(sum / (double)count);
    }
}

