/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.node.Node;
import java.util.List;

public class SequenceNode<T>
extends Node<T> {
    private final List<Node<T>> nodes;

    public SequenceNode(Adapter<T> runtime, List<Node<T>> nodes) {
        super(runtime);
        this.nodes = nodes;
    }

    @Override
    protected String internalToString() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (Node<T> node : this.nodes) {
            buffer.append(node).append(", ");
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        SequenceNode other = (SequenceNode)o;
        return this.nodes.equals(other.nodes);
    }

    @Override
    protected int internalHashCode() {
        return this.nodes.hashCode();
    }

    @Override
    public T search(T input) {
        T value = input;
        for (Node<T> node : this.nodes) {
            value = node.search(value);
        }
        return value;
    }
}

