/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.node.Node;
import java.util.ArrayList;
import java.util.List;

public class SliceNode<T>
extends Node<T> {
    private final boolean absoluteStart;
    private final boolean absoluteStop;
    private final boolean absoluteStep;
    private final int start;
    private final int stop;
    private final int step;
    private final int limit;
    private final int rounding;

    public SliceNode(Adapter<T> runtime, Integer start, Integer stop, Integer step) {
        super(runtime);
        this.absoluteStart = start != null;
        this.absoluteStop = stop != null;
        this.absoluteStep = step != null;
        this.step = step == null ? 1 : step;
        this.rounding = this.step < 0 ? this.step + 1 : this.step - 1;
        this.limit = this.step < 0 ? -1 : 0;
        int n = this.start = start == null ? this.limit : start;
        this.stop = stop == null ? (this.step < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE) : stop;
    }

    @Override
    public T search(T input) {
        List<T> elements = this.runtime.toList(input);
        int begin = this.start < 0 ? Math.max(elements.size() + this.start, 0) : Math.min(this.start, elements.size() + this.limit);
        int end = this.stop < 0 ? Math.max(elements.size() + this.stop, this.limit) : Math.min(this.stop, elements.size());
        int steps = Math.max(0, (end - begin + this.rounding) / this.step);
        ArrayList<T> output = new ArrayList<T>(steps);
        int i = 0;
        int offset = begin;
        while (i < steps) {
            output.add(elements.get(offset));
            ++i;
            offset += this.step;
        }
        return (T)this.runtime.createArray(output);
    }

    @Override
    protected String internalToString() {
        return String.format("%s, %s, %s", this.absoluteStart ? Integer.valueOf(this.start) : null, this.absoluteStop ? Integer.valueOf(this.stop) : null, this.absoluteStep ? Integer.valueOf(this.step) : null);
    }

    @Override
    protected boolean internalEquals(Object o) {
        SliceNode other = (SliceNode)o;
        return this.start == other.start && this.stop == other.stop && this.step == other.step;
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        h = h * 31 + this.start;
        h = h * 31 + this.stop;
        h = h * 31 + this.step;
        return h;
    }
}

