/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.parser;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.antlr.v4.runtime.Token;
import io.burt.jmespath.antlr.v4.runtime.tree.ParseTree;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArityException;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.node.CreateObjectNode;
import io.burt.jmespath.node.Node;
import io.burt.jmespath.node.NodeFactory;
import io.burt.jmespath.node.Operator;
import io.burt.jmespath.parser.JmesPathBaseVisitor;
import io.burt.jmespath.parser.JmesPathParser;
import io.burt.jmespath.parser.ParseErrorAccumulator;
import io.burt.jmespath.parser.ParseException;
import io.burt.jmespath.util.AntlrHelper;
import io.burt.jmespath.util.StringEscapeHelper;
import java.util.ArrayList;
import java.util.Arrays;

public class ExpressionParser<T>
extends JmesPathBaseVisitor<Node<T>> {
    private static final StringEscapeHelper identifierEscapeHelper = new StringEscapeHelper(true, '\"', '\"', '/', '/', '\\', '\\', 'b', '\b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t');
    private static final StringEscapeHelper rawStringEscapeHelper = new StringEscapeHelper(false, '\'', '\'', '\\', '\\');
    private static final StringEscapeHelper jsonLiteralEscapeHelper = new StringEscapeHelper(false, '`', '`');
    private final ParseTree tree;
    private final Adapter<T> runtime;
    private final NodeFactory<T> nodeFactory;
    private final ParseErrorAccumulator errors;
    private Node<T> chainedNode;

    public static <U> Expression<U> fromString(Adapter<U> runtime, String rawExpression) {
        ParseErrorAccumulator errors = new ParseErrorAccumulator();
        JmesPathParser parser = AntlrHelper.createParser(rawExpression, errors);
        JmesPathParser.JmesPathExpressionContext tree = parser.jmesPathExpression();
        Expression<U> expression = null;
        if (errors.isEmpty()) {
            ExpressionParser<U> visitor = new ExpressionParser<U>(runtime, tree, errors);
            expression = visitor.expression();
        }
        if (!errors.isEmpty()) {
            throw new ParseException(rawExpression, errors);
        }
        return expression;
    }

    private ExpressionParser(Adapter<T> runtime, ParseTree tree, ParseErrorAccumulator errors) {
        this.runtime = runtime;
        this.nodeFactory = runtime.nodeFactory();
        this.tree = tree;
        this.errors = errors;
    }

    public Expression<T> expression() {
        return (Expression)this.visit(this.tree);
    }

    private String identifierToString(JmesPathParser.IdentifierContext ctx) {
        String id = ctx.getText();
        if (ctx.STRING() != null) {
            id = identifierEscapeHelper.unescape(id.substring(1, id.length() - 1));
        }
        return id;
    }

    private void checkForUnescapedBackticks(Token token) {
        int unescapedBacktickIndex = this.indexOfUnescapedBacktick(token.getText());
        if (unescapedBacktickIndex > -1) {
            this.errors.parseError("syntax error unexpected `", token.getStartIndex() + unescapedBacktickIndex);
        }
    }

    private int indexOfUnescapedBacktick(String str) {
        int backtickIndex = str.indexOf(96);
        while (backtickIndex > -1) {
            if (backtickIndex == 0 || str.charAt(backtickIndex - 1) != '\\') {
                return backtickIndex;
            }
            backtickIndex = str.indexOf(96, backtickIndex + 1);
        }
        return -1;
    }

    private Node<T> createProjectionIfChained(Node<T> node) {
        if (this.chainedNode != null) {
            node = this.nodeFactory.createSequence(Arrays.asList(node, this.nodeFactory.createProjection(this.chainedNode)));
            this.chainedNode = null;
        }
        return node;
    }

    private Node<T> createSequenceIfChained(Node<T> node) {
        if (this.chainedNode != null) {
            node = this.nodeFactory.createSequence(Arrays.asList(node, this.chainedNode));
            this.chainedNode = null;
        }
        return node;
    }

    private Node<T> nonChainingVisit(ParseTree tree) {
        Node<T> stashedNextNode = this.chainedNode;
        this.chainedNode = null;
        Node<T> result = this.createSequenceIfChained((Node)this.visit(tree));
        this.chainedNode = stashedNextNode;
        return result;
    }

    @Override
    public Node<T> visitJmesPathExpression(JmesPathParser.JmesPathExpressionContext ctx) {
        return this.createSequenceIfChained((Node)this.visit(ctx.expression()));
    }

    @Override
    public Node<T> visitPipeExpression(JmesPathParser.PipeExpressionContext ctx) {
        Node<T> right = this.createSequenceIfChained((Node)this.visit(ctx.expression(1)));
        Node<T> left = this.createSequenceIfChained((Node)this.visit(ctx.expression(0)));
        return this.nodeFactory.createSequence(Arrays.asList(left, right));
    }

    @Override
    public Node<T> visitIdentifierExpression(JmesPathParser.IdentifierExpressionContext ctx) {
        return (Node)this.visit(ctx.identifier());
    }

    @Override
    public Node<T> visitNotExpression(JmesPathParser.NotExpressionContext ctx) {
        return this.nodeFactory.createNegate(this.createSequenceIfChained((Node)this.visit(ctx.expression())));
    }

    @Override
    public Node<T> visitRawStringExpression(JmesPathParser.RawStringExpressionContext ctx) {
        String quotedString = ctx.RAW_STRING().getText();
        String unquotedString = rawStringEscapeHelper.unescape(quotedString.substring(1, quotedString.length() - 1));
        return this.nodeFactory.createString(unquotedString);
    }

    @Override
    public Node<T> visitComparisonExpression(JmesPathParser.ComparisonExpressionContext ctx) {
        Operator operator = Operator.fromString(ctx.COMPARATOR().getText());
        Node<T> right = this.nonChainingVisit(ctx.expression(1));
        Node<T> left = this.nonChainingVisit(ctx.expression(0));
        return this.createSequenceIfChained(this.nodeFactory.createComparison(operator, left, right));
    }

    @Override
    public Node<T> visitParenExpression(JmesPathParser.ParenExpressionContext ctx) {
        return this.createSequenceIfChained(this.nonChainingVisit(ctx.expression()));
    }

    @Override
    public Node<T> visitBracketExpression(JmesPathParser.BracketExpressionContext ctx) {
        Node<T> result = (Node<T>)this.visit(ctx.bracketSpecifier());
        if (result == null) {
            result = this.chainedNode;
            this.chainedNode = null;
        }
        return result;
    }

    @Override
    public Node<T> visitOrExpression(JmesPathParser.OrExpressionContext ctx) {
        Node<T> left = this.nonChainingVisit(ctx.expression(0));
        Node<T> right = this.nonChainingVisit(ctx.expression(1));
        return this.createSequenceIfChained(this.nodeFactory.createOr(left, right));
    }

    @Override
    public Node<T> visitChainExpression(JmesPathParser.ChainExpressionContext ctx) {
        this.chainedNode = (Node)this.visit(ctx.chainedExpression());
        return this.createSequenceIfChained((Node)this.visit(ctx.expression()));
    }

    @Override
    public Node<T> visitAndExpression(JmesPathParser.AndExpressionContext ctx) {
        Node<T> left = this.nonChainingVisit(ctx.expression(0));
        Node<T> right = this.nonChainingVisit(ctx.expression(1));
        return this.createSequenceIfChained(this.nodeFactory.createAnd(left, right));
    }

    @Override
    public Node<T> visitWildcardExpression(JmesPathParser.WildcardExpressionContext ctx) {
        return (Node)this.visit(ctx.wildcard());
    }

    @Override
    public Node<T> visitBracketedExpression(JmesPathParser.BracketedExpressionContext ctx) {
        Node chainAfterExpression = (Node)this.visit(ctx.bracketSpecifier());
        Node<T> expression = this.createSequenceIfChained((Node)this.visit(ctx.expression()));
        this.chainedNode = chainAfterExpression;
        return this.createSequenceIfChained(expression);
    }

    @Override
    public Node<T> visitWildcard(JmesPathParser.WildcardContext ctx) {
        return this.createProjectionIfChained(this.nodeFactory.createFlattenObject());
    }

    @Override
    public Node<T> visitMultiSelectList(JmesPathParser.MultiSelectListContext ctx) {
        int n = ctx.expression().size();
        ArrayList<Node<T>> entries = new ArrayList<Node<T>>(n);
        for (int i = 0; i < n; ++i) {
            entries.add(this.nonChainingVisit(ctx.expression(i)));
        }
        return this.createSequenceIfChained(this.nodeFactory.createCreateArray(entries));
    }

    @Override
    public Node<T> visitMultiSelectHash(JmesPathParser.MultiSelectHashContext ctx) {
        int n = ctx.keyvalExpr().size();
        ArrayList entries = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            JmesPathParser.KeyvalExprContext kvCtx = ctx.keyvalExpr(i);
            String key = this.identifierToString(kvCtx.identifier());
            Node<T> value = this.nonChainingVisit(kvCtx.expression());
            entries.add(new CreateObjectNode.Entry<T>(key, value));
        }
        return this.createSequenceIfChained(this.nodeFactory.createCreateObject(entries));
    }

    @Override
    public Node<T> visitBracketIndex(JmesPathParser.BracketIndexContext ctx) {
        int index = Integer.parseInt(ctx.SIGNED_INT().getText());
        this.chainedNode = this.createSequenceIfChained(this.nodeFactory.createIndex(index));
        return null;
    }

    @Override
    public Node<T> visitBracketStar(JmesPathParser.BracketStarContext ctx) {
        Node<T> projection = this.chainedNode == null ? this.nodeFactory.createCurrent() : this.chainedNode;
        this.chainedNode = this.nodeFactory.createProjection(projection);
        return null;
    }

    @Override
    public Node<T> visitBracketSlice(JmesPathParser.BracketSliceContext ctx) {
        Integer start = null;
        Integer stop = null;
        Integer step = null;
        JmesPathParser.SliceContext sliceCtx = ctx.slice();
        if (sliceCtx.start != null) {
            start = Integer.parseInt(sliceCtx.start.getText());
        }
        if (sliceCtx.stop != null) {
            stop = Integer.parseInt(sliceCtx.stop.getText());
        }
        if (sliceCtx.step != null && (step = Integer.valueOf(Integer.parseInt(sliceCtx.step.getText()))) == 0) {
            this.errors.parseError(String.format("invalid value %d for step size", step), sliceCtx.step.getStartIndex());
        }
        this.chainedNode = this.createProjectionIfChained(this.nodeFactory.createSlice(start, stop, step));
        return null;
    }

    @Override
    public Node<T> visitBracketFlatten(JmesPathParser.BracketFlattenContext ctx) {
        return this.createProjectionIfChained(this.nodeFactory.createFlattenArray());
    }

    @Override
    public Node<T> visitSelect(JmesPathParser.SelectContext ctx) {
        this.chainedNode = this.createProjectionIfChained(this.nodeFactory.createSelection(this.nonChainingVisit(ctx.expression())));
        return null;
    }

    @Override
    public Node<T> visitFunctionExpression(JmesPathParser.FunctionExpressionContext ctx) {
        String name = ctx.NAME().getText();
        int n = ctx.functionArg().size();
        ArrayList<Node<T>> args = new ArrayList<Node<T>>(n);
        for (int i = 0; i < n; ++i) {
            args.add(this.nonChainingVisit(ctx.functionArg(i)));
        }
        Function implementation = this.runtime.functionRegistry().getFunction(name);
        if (implementation == null) {
            Token token = ctx.NAME().getSymbol();
            this.errors.parseError(String.format("unknown function \"%s\"", name), token.getStartIndex());
        } else {
            ArgumentConstraint argumentConstraints = implementation.argumentConstraints();
            if (argumentConstraints.arityViolated(n)) {
                Token token = ctx.NAME().getSymbol();
                String message = ArityException.createMessage(implementation, n, false);
                this.errors.parseError(message, token.getStartIndex());
            }
        }
        return this.createSequenceIfChained(this.nodeFactory.createFunctionCall(implementation, args));
    }

    @Override
    public Node<T> visitCurrentNode(JmesPathParser.CurrentNodeContext ctx) {
        if (this.chainedNode == null) {
            return this.nodeFactory.createCurrent();
        }
        Node<T> result = this.chainedNode;
        this.chainedNode = null;
        return result;
    }

    @Override
    public Node<T> visitExpressionType(JmesPathParser.ExpressionTypeContext ctx) {
        Node<T> expression = this.createSequenceIfChained((Node)this.visit(ctx.expression()));
        return this.nodeFactory.createExpressionReference(expression);
    }

    @Override
    public Node<T> visitLiteral(JmesPathParser.LiteralContext ctx) {
        this.visit(ctx.jsonValue());
        String string = jsonLiteralEscapeHelper.unescape(ctx.jsonValue().getText());
        return this.nodeFactory.createJsonLiteral(string);
    }

    @Override
    public Node<T> visitJsonStringValue(JmesPathParser.JsonStringValueContext ctx) {
        this.checkForUnescapedBackticks(ctx.getStart());
        return (Node)super.visitJsonStringValue(ctx);
    }

    @Override
    public Node<T> visitJsonObjectPair(JmesPathParser.JsonObjectPairContext ctx) {
        this.checkForUnescapedBackticks(ctx.STRING().getSymbol());
        return (Node)super.visitJsonObjectPair(ctx);
    }

    @Override
    public Node<T> visitIdentifier(JmesPathParser.IdentifierContext ctx) {
        return this.createSequenceIfChained(this.nodeFactory.createProperty(this.identifierToString(ctx)));
    }
}

