/*
 * Decompiled with CFR 0.152.
 */
package io.druid.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class Execs {
    public static ExecutorService singleThreaded(@NotNull String nameFormat) {
        return Execs.singleThreaded(nameFormat, null);
    }

    public static ExecutorService singleThreaded(@NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newSingleThreadExecutor(Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ExecutorService multiThreaded(int threads, @NotNull String nameFormat) {
        return Execs.multiThreaded(threads, nameFormat, null);
    }

    public static ExecutorService multiThreaded(int threads, @NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newFixedThreadPool(threads, Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ScheduledExecutorService scheduledSingleThreaded(@NotNull String nameFormat) {
        return Execs.scheduledSingleThreaded(nameFormat, null);
    }

    public static ScheduledExecutorService scheduledSingleThreaded(@NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newSingleThreadScheduledExecutor(Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ThreadFactory makeThreadFactory(@NotNull String nameFormat) {
        return Execs.makeThreadFactory(nameFormat, null);
    }

    public static ThreadFactory makeThreadFactory(@NotNull String nameFormat, @Nullable Integer priority) {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat);
        if (priority != null) {
            builder.setPriority(priority.intValue());
        }
        return builder.build();
    }

    public static ExecutorService newBlockingSingleThreaded(String nameFormat, int capacity) {
        return Execs.newBlockingSingleThreaded(nameFormat, capacity, null);
    }

    public static ExecutorService newBlockingSingleThreaded(String nameFormat, int capacity, Integer priority) {
        AbstractQueue queue = capacity > 0 ? new ArrayBlockingQueue(capacity) : new SynchronousQueue();
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), Execs.makeThreadFactory(nameFormat, priority), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException("Got Interrupted while adding to the Queue");
                }
            }
        });
    }
}

