/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.metamx.common.logger.Logger;
import io.druid.guice.LazySingleton;
import java.util.Map;
import org.skife.config.ConfigurationObjectFactory;

public class ConfigProvider<T>
implements Provider<T> {
    private static final Logger log = new Logger(ConfigProvider.class);
    private final Class<T> clazz;
    private final Map<String, String> replacements;
    private ConfigurationObjectFactory factory = null;

    public static <T> void bind(Binder binder, Class<T> clazz) {
        binder.bind(clazz).toProvider(ConfigProvider.of(clazz)).in(LazySingleton.class);
    }

    public static <T> void bind(Binder binder, Class<T> clazz, Map<String, String> replacements) {
        binder.bind(clazz).toProvider(ConfigProvider.of(clazz, replacements)).in(LazySingleton.class);
    }

    public static <T> Provider<T> of(Class<T> clazz) {
        return ConfigProvider.of(clazz, null);
    }

    public static <T> Provider<T> of(Class<T> clazz, Map<String, String> replacements) {
        return new ConfigProvider<T>(clazz, replacements);
    }

    public ConfigProvider(Class<T> clazz, Map<String, String> replacements) {
        this.clazz = clazz;
        this.replacements = replacements;
    }

    @Inject
    public void inject(ConfigurationObjectFactory factory) {
        this.factory = factory;
    }

    public T get() {
        try {
            Preconditions.checkNotNull((Object)this.factory, (Object)"WTF!? Code misconfigured, inject() didn't get called.");
            return (T)this.factory.buildWithReplacements(this.clazz, this.replacements);
        }
        catch (IllegalArgumentException e) {
            log.info("Unable to build instance of class[%s]", new Object[]{this.clazz});
            throw e;
        }
    }
}

