/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.common.config.ConfigManager;
import io.druid.common.config.ConfigManagerConfig;
import io.druid.common.config.JacksonConfigManager;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.metadata.MetadataStorageConnector;
import io.druid.metadata.MetadataStorageTablesConfig;

public class JacksonConfigManagerModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.config", ConfigManagerConfig.class);
        binder.bind(JacksonConfigManager.class).in(LazySingleton.class);
    }

    @Provides
    @ManageLifecycle
    public ConfigManager getConfigManager(final MetadataStorageConnector dbConnector, Supplier<MetadataStorageTablesConfig> dbTables, Supplier<ConfigManagerConfig> config, Lifecycle lifecycle) {
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                dbConnector.createConfigTable();
            }

            public void stop() {
            }
        });
        return new ConfigManager(dbConnector, dbTables, config);
    }
}

