package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeMetricsBuilder extends NodeMetricsFluentImpl<NodeMetricsBuilder> implements VisitableBuilder<NodeMetrics,NodeMetricsBuilder> {

    NodeMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public NodeMetricsBuilder() {
        this(true);
    }

    public NodeMetricsBuilder(Boolean validationEnabled) {
        this(new NodeMetrics(), validationEnabled);
    }

    public NodeMetricsBuilder(NodeMetricsFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodeMetrics(), validationEnabled);
    }

    public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,NodeMetrics instance) {
        this(fluent, instance, true);
    }

    public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,NodeMetrics instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withTimestamp(instance.getTimestamp()); 
        fluent.withUsage(instance.getUsage()); 
        fluent.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeMetricsBuilder(NodeMetrics instance) {
        this(instance,true);
    }

    public NodeMetricsBuilder(NodeMetrics instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTimestamp(instance.getTimestamp()); 
        this.withUsage(instance.getUsage()); 
        this.withWindow(instance.getWindow()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeMetrics build() {
        NodeMetrics buildable = new NodeMetrics(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getTimestamp(),fluent.getUsage(),fluent.getWindow());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeMetricsBuilder that = (NodeMetricsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
