package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodMetricsFluent<A extends PodMetricsFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToContainers(int index,ContainerMetrics item);
    public A setToContainers(int index,ContainerMetrics item);
    public A addToContainers(ContainerMetrics... items);
    public A addAllToContainers(Collection<ContainerMetrics> items);
    public A removeFromContainers(ContainerMetrics... items);
    public A removeAllFromContainers(Collection<ContainerMetrics> items);
    public A removeMatchingFromContainers(Predicate<ContainerMetricsBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerMetrics> getContainers();
    public List<ContainerMetrics> buildContainers();
    public ContainerMetrics buildContainer(int index);
    public ContainerMetrics buildFirstContainer();
    public ContainerMetrics buildLastContainer();
    public ContainerMetrics buildMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
    public Boolean hasMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
    public A withContainers(List<ContainerMetrics> containers);
    public A withContainers(ContainerMetrics... containers);
    public Boolean hasContainers();
    public PodMetricsFluent.ContainersNested<A> addNewContainer();
    public PodMetricsFluent.ContainersNested<A> addNewContainerLike(ContainerMetrics item);
    public PodMetricsFluent.ContainersNested<A> setNewContainerLike(int index,ContainerMetrics item);
    public PodMetricsFluent.ContainersNested<A> editContainer(int index);
    public PodMetricsFluent.ContainersNested<A> editFirstContainer();
    public PodMetricsFluent.ContainersNested<A> editLastContainer();
    public PodMetricsFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerMetricsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PodMetricsFluent.MetadataNested<A> withNewMetadata();
    public PodMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodMetricsFluent.MetadataNested<A> editMetadata();
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadata();
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getTimestamp();
    public A withTimestamp(String timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(StringBuilder arg1);
    public A withNewTimestamp(int[] arg1,int arg2,int arg3);
    public A withNewTimestamp(char[] arg1);
    public A withNewTimestamp(StringBuffer arg1);
    public A withNewTimestamp(byte[] arg1,int arg2);
    public A withNewTimestamp(byte[] arg1);
    public A withNewTimestamp(char[] arg1,int arg2,int arg3);
    public A withNewTimestamp(byte[] arg1,int arg2,int arg3);
    public A withNewTimestamp(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTimestamp(String arg1);
    public Duration getWindow();
    public A withWindow(Duration window);
    public Boolean hasWindow();
    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerMetricsFluent<PodMetricsFluent.ContainersNested<N>> {

            public N and();
            public N endContainer();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PodMetricsFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
