/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.configurable.ThreadPool;
import io.helidon.common.configurable.ThreadPoolSupplier;
import java.time.Duration;
import java.util.Optional;

@Prototype.Blueprint
@Prototype.Configured
interface ThreadPoolConfigBlueprint
extends Prototype.Factory<ThreadPoolSupplier> {
    public static final int DEFAULT_CORE_POOL_SIZE = 10;
    public static final int DEFAULT_MAX_POOL_SIZE = 50;
    public static final String DEFAULT_KEEP_ALIVE = "PT3M";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final boolean DEFAULT_IS_DAEMON = true;
    public static final String DEFAULT_THREAD_NAME_PREFIX = "helidon-";
    public static final boolean DEFAULT_PRESTART = true;
    public static final int DEFAULT_GROWTH_RATE = 0;
    public static final int DEFAULT_GROWTH_THRESHOLD = 1000;

    @Option.Configured
    public boolean virtualThreads();

    @Option.DefaultInt(value={10})
    @Option.Configured
    public int corePoolSize();

    @Option.DefaultInt(value={50})
    @Option.Configured
    public int maxPoolSize();

    @Option.Default(value={"PT3M"})
    @Option.Configured
    public Duration keepAlive();

    @Option.DefaultInt(value={10000})
    @Option.Configured
    public int queueCapacity();

    @Option.DefaultBoolean(value={true})
    @Option.Configured(value="is-daemon")
    public boolean daemon();

    @Option.Configured
    public Optional<String> name();

    @Option.DefaultInt(value={1000})
    @Option.Configured
    public int growthThreshold();

    @Option.DefaultInt(value={0})
    @Option.Configured
    public int growthRate();

    @Option.DefaultCode(value="ThreadPoolSupplier.DEFAULT_REJECTION_POLICY")
    public ThreadPool.RejectionHandler rejectionHandler();

    @Option.Configured
    public Optional<String> threadNamePrefix();

    @Option.DefaultBoolean(value={true})
    @Option.Configured
    public boolean shouldPrestart();
}

