/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.Metrics;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.ContainerMetrics;
import io.kubernetes.client.custom.NodeMetrics;
import io.kubernetes.client.custom.NodeMetricsList;
import io.kubernetes.client.custom.PodMetrics;
import io.kubernetes.client.custom.PodMetricsList;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class KubectlTop<ApiType extends KubernetesObject, MetricsType>
extends Kubectl.ResourceBuilder<ApiType, KubectlTop<ApiType, MetricsType>>
implements Kubectl.Executable<List<Pair<ApiType, MetricsType>>> {
    String metricName = "cpu";

    KubectlTop(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlTop<ApiType, MetricsType> metric(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @Override
    public List<Pair<ApiType, MetricsType>> execute() throws KubectlException {
        switch (this.metricName) {
            case "cpu": 
            case "memory": {
                break;
            }
            default: {
                throw new KubectlException("Unknown metric: " + this.metricName);
            }
        }
        try {
            CoreV1Api api = new CoreV1Api(this.apiClient);
            if (this.apiTypeClass.equals(V1Node.class)) {
                return this.topNodes(api, this.apiClient, this.metricName);
            }
            if (this.apiTypeClass.equals(V1Pod.class)) {
                return this.topPods(api, this.apiClient, this.metricName);
            }
            throw new KubectlException("Can not perform top for " + this.apiTypeClass.getName());
        }
        catch (ApiException | IOException ex) {
            throw new KubectlException(ex);
        }
    }

    private NodeMetrics findNodeMetric(String nodeName, NodeMetricsList list) {
        for (NodeMetrics metric : list.getItems()) {
            if (!metric.getMetadata().getName().equals(nodeName)) continue;
            return metric;
        }
        return null;
    }

    private NodeMetrics findNodeMetric(V1Node node, NodeMetricsList list) {
        return this.findNodeMetric(node.getMetadata().getName(), list);
    }

    static double findNodePercentage(V1Node node, Quantity value, String metric) {
        Quantity capacity = (Quantity)node.getStatus().getCapacity().get(metric);
        if (capacity == null) {
            return Double.POSITIVE_INFINITY;
        }
        return value.getNumber().doubleValue() / capacity.getNumber().doubleValue();
    }

    private List<Pair<ApiType, MetricsType>> topNodes(CoreV1Api api, ApiClient apiClient, final String metricName) throws KubectlException, ApiException, IOException {
        V1NodeList nodes = api.listNode(null, null, null, null, null, null, null, null, null, null, null);
        final NodeMetricsList metrics = new Metrics(apiClient).getNodeMetrics();
        List items = nodes.getItems();
        Collections.sort(items, new Comparator<V1Node>(){

            @Override
            public int compare(V1Node arg0, V1Node arg1) {
                Quantity m0 = (Quantity)KubectlTop.this.findNodeMetric(arg0.getMetadata().getName(), metrics).getUsage().get(metricName);
                Quantity m1 = (Quantity)KubectlTop.this.findNodeMetric(arg1.getMetadata().getName(), metrics).getUsage().get(metricName);
                double p0 = KubectlTop.findNodePercentage(arg0, m0, metricName);
                double p1 = KubectlTop.findNodePercentage(arg1, m1, metricName);
                return Double.compare(p0, p1) * -1;
            }
        });
        ArrayList<Pair<ApiType, MetricsType>> result = new ArrayList<Pair<ApiType, MetricsType>>();
        for (V1Node node : items) {
            result.add((Pair<ApiType, MetricsType>)new ImmutablePair((Object)node, (Object)this.findNodeMetric(node, metrics)));
        }
        return result;
    }

    private static PodMetrics findPodMetric(String podName, PodMetricsList list) {
        for (PodMetrics metric : list.getItems()) {
            if (!metric.getMetadata().getName().equals(podName)) continue;
            return metric;
        }
        return null;
    }

    private static PodMetrics findPodMetric(V1Pod pod, PodMetricsList list) {
        return KubectlTop.findPodMetric(pod.getMetadata().getName(), list);
    }

    public static double podMetricSum(PodMetrics podMetrics, String metricName) {
        double sum = 0.0;
        for (ContainerMetrics containerMetrics : podMetrics.getContainers()) {
            Quantity value = (Quantity)containerMetrics.getUsage().get(metricName);
            if (value == null) continue;
            sum += value.getNumber().doubleValue();
        }
        return sum;
    }

    private List<Pair<ApiType, MetricsType>> topPods(CoreV1Api api, ApiClient apiClient, final String metricName) throws KubectlException, ApiException, IOException {
        V1PodList pods = api.listNamespacedPod(this.namespace, null, null, null, null, null, null, null, null, null, null, null);
        final PodMetricsList metrics = new Metrics(apiClient).getPodMetrics(this.namespace);
        List items = pods.getItems();
        Collections.sort(items, new Comparator<V1Pod>(){

            @Override
            public int compare(V1Pod arg0, V1Pod arg1) {
                double m0 = KubectlTop.podMetricSum(KubectlTop.findPodMetric(arg0.getMetadata().getName(), metrics), metricName);
                double m1 = KubectlTop.podMetricSum(KubectlTop.findPodMetric(arg1.getMetadata().getName(), metrics), metricName);
                return Double.compare(m0, m1) * -1;
            }
        });
        ArrayList<Pair<ApiType, MetricsType>> result = new ArrayList<Pair<ApiType, MetricsType>>();
        for (V1Pod pod : items) {
            result.add((Pair<ApiType, MetricsType>)new ImmutablePair((Object)pod, (Object)KubectlTop.findPodMetric(pod, metrics)));
        }
        return result;
    }
}

