/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.util.ArrayList;
import java.util.List;

public class ClientListArgs
implements CompositeArgument {
    private List<Long> ids;
    private Type type;

    public ClientListArgs ids(long ... ids) {
        LettuceAssert.notNull((Object)ids, "Ids must not be null");
        this.ids = new ArrayList<Long>(ids.length);
        for (long id : ids) {
            this.ids.add(id);
        }
        return this;
    }

    public ClientListArgs type(Type type) {
        LettuceAssert.notNull((Object)type, "Type must not be null");
        this.type = type;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ids != null && !this.ids.isEmpty()) {
            args.add(CommandKeyword.ID);
            for (Long id : this.ids) {
                args.add(id);
            }
        }
        if (this.type != null) {
            args.add(CommandType.TYPE).add(this.type.name().toLowerCase());
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static ClientListArgs ids(long ... id) {
            return new ClientListArgs().ids(id);
        }

        public static ClientListArgs typePubsub() {
            return new ClientListArgs().type(Type.PUBSUB);
        }

        public static ClientListArgs typeNormal() {
            return new ClientListArgs().type(Type.NORMAL);
        }

        public static ClientListArgs typeMaster() {
            return new ClientListArgs().type(Type.MASTER);
        }

        public static ClientListArgs typeReplica() {
            return new ClientListArgs().type(Type.REPLICA);
        }
    }

    private static enum Type {
        NORMAL,
        MASTER,
        REPLICA,
        PUBSUB;

    }
}

