/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceFactories;
import io.lettuce.core.output.ArrayComplexData;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.output.MapComplexData;
import io.lettuce.core.output.SetComplexData;
import java.nio.ByteBuffer;
import java.util.Deque;

public class ComplexOutput<K, V, T>
extends CommandOutput<K, V, T> {
    private final Deque<ComplexData> dataStack = LettuceFactories.newSpScQueue();
    private final ComplexDataParser<T> parser;
    private ComplexData data;

    public ComplexOutput(RedisCodec<K, V> codec, ComplexDataParser<T> parser) {
        super(codec, null);
        this.parser = parser;
    }

    @Override
    public T get() {
        return this.parser.parse(this.data);
    }

    @Override
    public void set(long integer) {
        if (this.data == null) {
            throw new RuntimeException("Invalid output received for dynamic aggregate output.Integer value should have been preceded by some sort of aggregation.");
        }
        this.data.store(integer);
    }

    @Override
    public void set(double number) {
        if (this.data == null) {
            throw new RuntimeException("Invalid output received for dynamic aggregate output.Double value should have been preceded by some sort of aggregation.");
        }
        this.data.store(number);
    }

    @Override
    public void set(boolean value) {
        if (this.data == null) {
            throw new RuntimeException("Invalid output received for dynamic aggregate output.Double value should have been preceded by some sort of aggregation.");
        }
        this.data.store(value);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.data == null) {
            return;
        }
        this.data.storeObject(bytes == null ? null : this.codec.decodeValue(bytes));
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        if (this.data == null) {
            throw new RuntimeException("Invalid output received for dynamic aggregate output.String value should have been preceded by some sort of aggregation.");
        }
        this.data.store(bytes == null ? null : StringCodec.UTF8.decodeValue(bytes));
    }

    @Override
    public void complete(int depth) {
        if (!this.dataStack.isEmpty() && depth == this.dataStack.size()) {
            this.data = this.dataStack.pop();
        }
    }

    private void multi(ComplexData newData) {
        if (this.data == null) {
            this.data = newData;
            return;
        }
        this.data.storeObject(newData);
        this.dataStack.push(this.data);
        this.data = newData;
    }

    @Override
    public void multiSet(int count) {
        if (count < 0) {
            return;
        }
        SetComplexData dynamicData = new SetComplexData(count);
        this.multi(dynamicData);
    }

    @Override
    public void multiArray(int count) {
        if (count < 0) {
            return;
        }
        ArrayComplexData dynamicData = new ArrayComplexData(count);
        this.multi(dynamicData);
    }

    @Override
    public void multiMap(int count) {
        if (count < 0) {
            return;
        }
        MapComplexData dynamicData = new MapComplexData(count);
        this.multi(dynamicData);
    }
}

