/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.TimeWindowHistogram;
import io.micrometer.core.instrument.util.MeterEquivalence;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    private final TimeWindowHistogram histogram;
    private final HistogramConfig histogramConfig;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id);
        this.histogram = new TimeWindowHistogram(clock, histogramConfig);
        this.histogramConfig = histogramConfig;
    }

    @Override
    public final void record(double amount) {
        if (amount >= 0.0) {
            this.histogram.recordDouble(amount);
            this.recordNonNegative(amount);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public double percentile(double percentile) {
        return this.histogram.percentile(percentile);
    }

    @Override
    public double histogramCountAtValue(long value) {
        return this.histogram.histogramCountAtValue(value);
    }

    @Override
    public HistogramSnapshot takeSnapshot(boolean supportsAggregablePercentiles) {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max(), supportsAggregablePercentiles);
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }

    public HistogramConfig statsConfig() {
        return this.histogramConfig;
    }
}

