/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.okhttp3;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpMetricsEventListener
extends EventListener {
    public static final String URI_PATTERN = "URI_PATTERN";
    private final String requestsMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<Tag> extraTags;
    private final MeterRegistry registry;
    private final ConcurrentHashMap<Call, CallState> callState = new ConcurrentHashMap();

    OkHttpMetricsEventListener(MeterRegistry registry, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags) {
        this.registry = registry;
        this.requestsMetricName = requestsMetricName;
        this.urlMapper = urlMapper;
        this.extraTags = extraTags;
    }

    public void callStart(Call call) {
        this.callState.put(call, new CallState(this.registry.config().clock().monotonicTime()));
    }

    public void requestHeadersEnd(Call call, Request request) {
        this.callState.computeIfPresent(call, (c, state) -> {
            state.request = request;
            return state;
        });
    }

    public void callFailed(Call call, IOException e) {
        CallState state = this.callState.remove(call);
        if (state != null) {
            state.exception = e;
            this.time(state);
        }
    }

    public void responseHeadersEnd(Call call, Response response) {
        CallState state = this.callState.remove(call);
        if (state != null) {
            state.response = response;
            this.time(state);
        }
    }

    private void time(CallState state) {
        String uri = state.response == null ? "UNKNOWN" : (state.response.code() == 404 || state.response.code() == 301 ? "NOT_FOUND" : this.urlMapper.apply(state.request));
        Iterable<Tag> tags = Tags.concat(this.extraTags, Tags.zip("method", state.request != null ? state.request.method() : "UNKNOWN", "uri", uri, "status", this.getStatusMessage(state.response, state.exception), "host", state.request != null ? state.request.url().host() : "UNKNOWN"));
        Timer.builder(this.requestsMetricName).tags(tags).description("Timer of OkHttp operation").register(this.registry).record(this.registry.config().clock().monotonicTime() - state.startTime, TimeUnit.NANOSECONDS);
    }

    private String getStatusMessage(Response response, IOException exception) {
        if (exception != null) {
            return "IO_ERROR";
        }
        if (response == null) {
            return "CLIENT_ERROR";
        }
        return Integer.toString(response.code());
    }

    public static Builder builder(MeterRegistry registry, String name) {
        return new Builder(registry, name);
    }

    public static class Builder {
        private MeterRegistry registry;
        private String name;
        private Function<Request, String> uriMapper = request -> Optional.ofNullable(request.header(OkHttpMetricsEventListener.URI_PATTERN)).orElse("none");
        private List<Tag> tags;

        Builder(MeterRegistry registry, String name) {
            this.registry = registry;
            this.name = name;
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder uriMapper(Function<Request, String> uriMapper) {
            this.uriMapper = uriMapper;
            return this;
        }

        public OkHttpMetricsEventListener build() {
            return new OkHttpMetricsEventListener(this.registry, this.name, this.uriMapper, this.tags);
        }
    }

    private static class CallState {
        final long startTime;
        Request request;
        Response response;
        IOException exception;

        CallState(long startTime) {
            this.startTime = startTime;
        }
    }
}

