/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.stream.Stream;

abstract class AbstractCompositeMeter<T extends Meter>
extends AbstractMeter
implements CompositeMeter {
    private static final AtomicReferenceFieldUpdater<AbstractCompositeMeter, Meter> firstMeterUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractCompositeMeter.class, Meter.class, "firstMeter");
    private final List<Entry> children = new CopyOnWriteArrayList<Entry>();
    private volatile T firstMeter;
    private volatile T noopMeter;

    AbstractCompositeMeter(Meter.Id id) {
        super(id);
    }

    abstract T newNoopMeter();

    abstract T registerNewMeter(MeterRegistry var1);

    final void forEachChild(Consumer<T> task) {
        this.children.forEach(e -> task.accept(e.meter()));
    }

    final Stream<T> childStream() {
        return this.children.stream().map(Entry::meter);
    }

    final T firstChild() {
        block3: {
            T firstMeter;
            do {
                if ((firstMeter = this.firstMeter) != null) {
                    return firstMeter;
                }
                firstMeter = this.findFirstChild();
                if (firstMeter == null) break block3;
            } while (!firstMeterUpdater.compareAndSet(this, (Meter)null, (Meter)firstMeter));
            return firstMeter;
        }
        T noopMeter = this.noopMeter;
        if (noopMeter != null) {
            return noopMeter;
        }
        this.noopMeter = this.newNoopMeter();
        return this.noopMeter;
    }

    private T findFirstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        Iterator<Entry> i = this.children.iterator();
        return (T)(i.hasNext() ? (Meter)i.next().meter() : null);
    }

    @Override
    public final void add(MeterRegistry registry) {
        T newMeter = this.registerNewMeter(registry);
        if (newMeter == null) {
            return;
        }
        this.children.add(new Entry(registry, (Meter)newMeter));
        firstMeterUpdater.compareAndSet(this, (Meter)null, (Meter)newMeter);
    }

    @Override
    public final void remove(MeterRegistry registry) {
        AtomicReference meterHolder = new AtomicReference();
        this.children.removeIf(e -> {
            if (e.registry() == registry) {
                meterHolder.set(e.meter());
                return true;
            }
            return false;
        });
        Meter removedMeter = (Meter)meterHolder.get();
        if (removedMeter != null) {
            firstMeterUpdater.compareAndSet(this, removedMeter, null);
        }
    }

    private static final class Entry {
        private final MeterRegistry registry;
        private final Meter meter;

        Entry(MeterRegistry registry, Meter meter) {
            this.registry = registry;
            this.meter = meter;
        }

        MeterRegistry registry() {
            return this.registry;
        }

        <U> U meter() {
            return (U)this.meter;
        }
    }
}

