/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

class CompositeLongTaskTimer
extends AbstractCompositeMeter<LongTaskTimer>
implements LongTaskTimer {
    private final AtomicLong nextTask = new AtomicLong(0L);
    private final ConcurrentMap<Long, Collection<TaskIdMapping>> taskMapping = new ConcurrentHashMap<Long, Collection<TaskIdMapping>>();

    CompositeLongTaskTimer(Meter.Id id) {
        super(id);
    }

    @Override
    public long start() {
        long task = this.nextTask.getAndIncrement();
        this.taskMapping.put(task, this.childStream().map(ltt -> new TaskIdMapping(ltt.start(), (LongTaskTimer)ltt)).collect(Collectors.toList()));
        return task;
    }

    @Override
    public long stop(long task) {
        Collection mappings = (Collection)this.taskMapping.remove(task);
        long last = 0L;
        if (mappings != null) {
            for (TaskIdMapping mapping : mappings) {
                last = mapping.ltt.stop(mapping.id);
            }
        }
        return last;
    }

    @Override
    public double duration(long task, TimeUnit unit) {
        Iterator iterator;
        Collection mappings = (Collection)this.taskMapping.get(task);
        if (mappings != null && (iterator = mappings.iterator()).hasNext()) {
            TaskIdMapping mapping = (TaskIdMapping)iterator.next();
            return mapping.ltt.duration(mapping.id, unit);
        }
        return -1.0;
    }

    @Override
    public double duration(TimeUnit unit) {
        return ((LongTaskTimer)this.firstChild()).duration(unit);
    }

    @Override
    public int activeTasks() {
        return ((LongTaskTimer)this.firstChild()).activeTasks();
    }

    @Override
    LongTaskTimer newNoopMeter() {
        return new NoopLongTaskTimer(this.getId());
    }

    @Override
    LongTaskTimer registerNewMeter(MeterRegistry registry) {
        return LongTaskTimer.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).register(registry);
    }

    private static class TaskIdMapping {
        private final long id;
        private final LongTaskTimer ltt;

        private TaskIdMapping(long id, LongTaskTimer ltt) {
            this.id = id;
            this.ltt = ltt;
        }
    }
}

