/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.step.StepLong;
import java.util.Arrays;

public class StepDistributionSummary
extends AbstractDistributionSummary {
    private final StepLong count;
    private final StepDouble total;
    private final TimeWindowMax max;

    @Deprecated
    public StepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        this(id, clock, distributionStatisticConfig, scale, false);
    }

    public StepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        super(id, clock, distributionStatisticConfig, scale, supportsAggregablePercentiles);
        this.count = new StepLong(clock, distributionStatisticConfig.getExpiry().toMillis());
        this.total = new StepDouble(clock, distributionStatisticConfig.getExpiry().toMillis());
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.getCurrent().add(1L);
        this.total.getCurrent().add(amount);
        this.max.record(amount);
    }

    @Override
    public long count() {
        return (long)this.count.poll();
    }

    @Override
    public double totalAmount() {
        return this.total.poll();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL), new Measurement(this::max, Statistic.MAX));
    }
}

