/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.jdbc.operations;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.ConnectionSynchronization;
import io.micronaut.data.connection.exceptions.ConnectionException;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.connection.jdbc.exceptions.CannotGetJdbcConnectionException;
import io.micronaut.data.connection.support.AbstractConnectionOperations;
import io.micronaut.data.connection.support.JdbcConnectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@EachBean(value=DataSource.class)
public final class DefaultDataSourceConnectionOperations
extends AbstractConnectionOperations<Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataSourceConnectionOperations.class);
    private final DataSource dataSource;

    DefaultDataSourceConnectionOperations(DataSource dataSource) {
        this.dataSource = DelegatingDataSource.unwrapDataSource(dataSource);
    }

    protected Connection openConnection(ConnectionDefinition definition) {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Failed to obtain JDBC Connection", e);
        }
    }

    protected void setupConnection(ConnectionStatus<Connection> connectionStatus) {
        connectionStatus.getDefinition().isReadOnly().ifPresent(readOnly -> {
            final ArrayList onCompleteCallbacks = new ArrayList(1);
            JdbcConnectionUtils.applyReadOnly((Logger)LOG, (Connection)((Connection)connectionStatus.getConnection()), (boolean)readOnly, onCompleteCallbacks);
            if (!onCompleteCallbacks.isEmpty()) {
                connectionStatus.registerSynchronization(new ConnectionSynchronization(){

                    public void executionComplete() {
                        for (Runnable onCompleteCallback : onCompleteCallbacks) {
                            onCompleteCallback.run();
                        }
                    }
                });
            }
        });
    }

    protected void closeConnection(ConnectionStatus<Connection> connectionStatus) {
        try {
            ((Connection)connectionStatus.getConnection()).close();
        }
        catch (SQLException e) {
            throw new ConnectionException("Failed to close the connection: " + e.getMessage(), (Throwable)e);
        }
    }
}

