/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.file;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultFileSystemResourceLoader
implements FileSystemResourceLoader {
    private final Path baseDirPath;
    private final boolean baseExists;

    public DefaultFileSystemResourceLoader() {
        this.baseDirPath = null;
        this.baseExists = true;
    }

    public DefaultFileSystemResourceLoader(File baseDirPath) {
        this(baseDirPath.toPath().normalize());
    }

    public DefaultFileSystemResourceLoader(String path) {
        this(Paths.get(DefaultFileSystemResourceLoader.normalize(path), new String[0]));
    }

    public DefaultFileSystemResourceLoader(Path path) {
        Path baseDirPath;
        try {
            baseDirPath = path.normalize().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            baseDirPath = null;
        }
        this.baseExists = baseDirPath != null;
        this.baseDirPath = baseDirPath;
    }

    @Override
    public Optional<InputStream> getResourceAsStream(String path) {
        Path filePath = this.getFilePath(DefaultFileSystemResourceLoader.normalize(path));
        if (this.isResolvableFile(filePath)) {
            try {
                return Optional.of(Files.newInputStream(filePath, new OpenOption[0]));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<URL> getResource(String path) {
        Path filePath = this.getFilePath(DefaultFileSystemResourceLoader.normalize(path));
        if (this.isResolvableFile(filePath)) {
            try {
                URL url = filePath.toUri().toURL();
                return Optional.of(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Stream<URL> getResources(String name) {
        return this.getResource(name).map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public ResourceLoader forBase(String basePath) {
        return new DefaultFileSystemResourceLoader(basePath);
    }

    private boolean isResolvableFile(Path filePath) {
        return this.startsWithBase(filePath) && Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath) && !Files.isDirectory(filePath, new LinkOption[0]);
    }

    private static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        return path;
    }

    private Path getFilePath(String path) {
        if (this.baseDirPath != null) {
            return this.baseDirPath.resolve(path);
        }
        return Paths.get(path, new String[0]);
    }

    private boolean startsWithBase(Path path) {
        if (this.baseDirPath != null) {
            try {
                Path relativePath = this.baseDirPath.resolve(path).toRealPath(new LinkOption[0]);
                return relativePath.startsWith(this.baseDirPath);
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.baseExists;
    }
}

