/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataWriter;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public class ConfigurationMetadataProcessor
extends AbstractInjectAnnotationProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return CollectionUtils.setOf((Object[])new String[]{ConfigurationReader.class.getName(), ConfigurationProperties.class.getName(), EachProperty.class.getName()});
    }

    @Override
    protected TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.AGGREGATING;
    }

    @Override
    protected String getIncrementalProcessorType() {
        return "org.gradle.annotation.processing.aggregating";
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.writeConfigurationMetadata();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigurationMetadata() {
        block6: {
            try {
                ConfigurationMetadataBuilder builder = ConfigurationMetadataBuilder.INSTANCE;
                if (!builder.hasMetadata()) break block6;
                ServiceLoader<ConfigurationMetadataWriter> writers = ServiceLoader.load(ConfigurationMetadataWriter.class, this.getClass().getClassLoader());
                try {
                    for (ConfigurationMetadataWriter writer : writers) {
                        this.writeConfigurationMetadata(builder, writer);
                    }
                }
                catch (ServiceConfigurationError e) {
                    this.warning("Unable to load ConfigurationMetadataWriter due to : %s", e.getMessage());
                }
            }
            finally {
                ConfigurationMetadataBuilder.reset();
            }
        }
    }

    private void writeConfigurationMetadata(ConfigurationMetadataBuilder metadataBuilder, ConfigurationMetadataWriter writer) {
        try {
            writer.write(metadataBuilder, (ClassWriterOutputVisitor)this.classWriterOutputVisitor);
        }
        catch (IOException e) {
            this.warning("Error occurred writing configuration metadata: %s", e.getMessage());
        }
    }
}

