/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.PropertyElementAnnotationMetadata;
import java.util.Optional;

@Internal
final class JavaPropertyElement
extends AbstractJavaElement
implements PropertyElement {
    private final ClassElement type;
    private final String name;
    private final PropertyElement.AccessKind readAccessKind;
    private final PropertyElement.AccessKind writeAccessKind;
    private final ClassElement owningElement;
    @Nullable
    private final MethodElement getter;
    @Nullable
    private final MethodElement setter;
    @Nullable
    private final FieldElement field;
    private final boolean excluded;
    private final ElementAnnotationMetadata annotationMetadata;

    JavaPropertyElement(ClassElement owningElement, ClassElement type, MethodElement getter, MethodElement setter, FieldElement field, ElementAnnotationMetadataFactory annotationMetadataFactory, String name, PropertyElement.AccessKind readAccessKind, PropertyElement.AccessKind writeAccessKind, boolean excluded, JavaVisitorContext visitorContext) {
        super(JavaPropertyElement.selectNativeType(getter, setter, field), annotationMetadataFactory, visitorContext);
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        this.field = field;
        this.name = name;
        this.readAccessKind = readAccessKind;
        this.writeAccessKind = writeAccessKind;
        this.owningElement = owningElement;
        this.excluded = excluded;
        this.annotationMetadata = new PropertyElementAnnotationMetadata((Element)this, getter, setter, field, null, false);
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaPropertyElement(this.owningElement, this.type, this.getter, this.setter, this.field, this.elementAnnotationMetadataFactory, this.name, this.readAccessKind, this.writeAccessKind, this.excluded, this.visitorContext);
    }

    public PropertyElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (PropertyElement)super.withAnnotationMetadata(annotationMetadata);
    }

    private static JavaNativeElement selectNativeType(MethodElement getter, MethodElement setter, FieldElement field) {
        if (getter != null) {
            return (JavaNativeElement)getter.getNativeType();
        }
        if (setter != null) {
            return (JavaNativeElement)setter.getNativeType();
        }
        if (field != null) {
            return (JavaNativeElement)field.getNativeType();
        }
        throw new IllegalStateException();
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public ElementAnnotationMetadata getElementAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public ClassElement getType() {
        return this.type;
    }

    public ClassElement getGenericType() {
        return this.type;
    }

    public Optional<FieldElement> getField() {
        return Optional.ofNullable(this.field);
    }

    public Optional<MethodElement> getWriteMethod() {
        return Optional.ofNullable(this.setter);
    }

    public Optional<MethodElement> getReadMethod() {
        return Optional.ofNullable(this.getter);
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public PropertyElement.AccessKind getReadAccessKind() {
        return this.readAccessKind;
    }

    public PropertyElement.AccessKind getWriteAccessKind() {
        return this.writeAccessKind;
    }

    public boolean isReadOnly() {
        switch (this.writeAccessKind) {
            case METHOD: {
                return this.setter == null;
            }
            case FIELD: {
                return this.field == null || this.field.isFinal();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isWriteOnly() {
        switch (this.readAccessKind) {
            case METHOD: {
                return this.getter == null;
            }
            case FIELD: {
                return this.field == null;
            }
        }
        throw new IllegalStateException();
    }

    public ClassElement getDeclaringType() {
        if (this.field != null) {
            return this.field.getDeclaringType();
        }
        if (this.getter != null) {
            return this.getter.getDeclaringType();
        }
        if (this.setter != null) {
            return this.setter.getDeclaringType();
        }
        throw new IllegalStateException();
    }

    public ClassElement getOwningType() {
        return this.owningElement;
    }
}

