/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.configproperties.ClassConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesMetadataBuildItem;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.arc.deployment.configproperties.InterfaceConfigPropertiesUtil;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ConfigPropertiesBuildStep {
    @BuildStep
    void produceConfigPropertiesMetadata(CombinedIndexBuildItem combinedIndex, ArcConfig arcConfig, BuildProducer<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataProducer) {
        for (AnnotationInstance annotation : combinedIndex.getIndex().getAnnotations(DotNames.CONFIG_PROPERTIES)) {
            configPropertiesMetadataProducer.produce((BuildItem)new ConfigPropertiesMetadataBuildItem(annotation, arcConfig.configPropertiesDefaultNamingStrategy));
        }
    }

    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndex, List<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataList, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        if (configPropertiesMetadataList.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GeneratedClassGizmoAdaptor nonBeansClassOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        ClassCreator producerClassCreator = ClassCreator.builder().classOutput((ClassOutput)beansClassOutput).className("io.quarkus.arc.runtime.config.ConfigPropertiesProducer").build();
        producerClassCreator.addAnnotation(Singleton.class);
        HashSet<DotName> configClassesThatNeedValidation = new HashSet<DotName>(configPropertiesMetadataList.size());
        for (ConfigPropertiesMetadataBuildItem configPropertiesMetadata : configPropertiesMetadataList) {
            ClassInfo classInfo = configPropertiesMetadata.getClassInfo();
            if (Modifier.isInterface(classInfo.flags())) {
                String generatedClassName = InterfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigProperties(classInfo, (ClassOutput)nonBeansClassOutput, combinedIndex.getIndex(), configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), defaultConfigValues, configProperties);
                InterfaceConfigPropertiesUtil.addProducerMethodForInterfaceConfigProperties(producerClassCreator, classInfo.name(), generatedClassName);
                continue;
            }
            boolean needsValidation = ClassConfigPropertiesUtil.addProducerMethodForClassConfigProperties(Thread.currentThread().getContextClassLoader(), classInfo, producerClassCreator, configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), combinedIndex.getIndex(), configProperties);
            if (!needsValidation) continue;
            configClassesThatNeedValidation.add(classInfo.name());
        }
        producerClassCreator.close();
        if (!configClassesThatNeedValidation.isEmpty()) {
            ClassConfigPropertiesUtil.generateStartupObserverThatInjectsConfigClass(beansClassOutput, configClassesThatNeedValidation);
        }
    }
}

