/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    private static final int DEFAULT_ORDINAL = 300;
    private final Map<EnvProperty, String> properties;
    private final Set<String> names;

    protected EnvConfigSource() {
        this(300);
    }

    protected EnvConfigSource(int ordinal) {
        this(EnvConfigSource.getEnvProperties(), ordinal);
    }

    public EnvConfigSource(Map<String, String> properties, int ordinal) {
        super("EnvConfigSource", EnvConfigSource.getEnvOrdinal(properties, ordinal));
        this.properties = new HashMap<EnvProperty, String>(properties.size());
        this.names = new HashSet<String>(properties.size() * 2);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.properties.put(new EnvProperty(entry.getKey()), entry.getValue());
            this.names.add(entry.getKey());
            this.names.add(StringUtil.toLowerCaseAndDotted((String)entry.getKey()));
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.properties.size());
        for (Map.Entry<EnvProperty, String> entry : this.properties.entrySet()) {
            properties.put(entry.getKey().getName(), entry.getValue());
        }
        return properties;
    }

    public Set<String> getPropertyNames() {
        return this.names;
    }

    public String getValue(String propertyName) {
        return this.properties.get(new EnvProperty(propertyName));
    }

    boolean hasPropertyName(String propertyName) {
        return this.properties.containsKey(new EnvProperty(propertyName));
    }

    private static Map<String, String> getEnvProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return new HashMap<String, String>(System.getenv());
            }
        });
    }

    private static int getEnvOrdinal(Map<String, String> properties, int ordinal) {
        String value = properties.get("config_ordinal");
        if (value == null) {
            value = properties.get("config_ordinal".toUpperCase());
        }
        if (value != null) {
            return (Integer)Converters.INTEGER_CONVERTER.convert(value);
        }
        return ordinal;
    }

    Object writeReplace() {
        return new Ser();
    }

    static final class EnvProperty
    implements Serializable {
        private static final long serialVersionUID = -2679716955093904512L;
        private final String name;

        public EnvProperty(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnvProperty that = (EnvProperty)o;
            return EnvProperty.equals(this.name, that.name);
        }

        public int hashCode() {
            int h = 0;
            int length = this.name.length();
            if (length >= 2 && this.name.charAt(length - 1) == '_' && this.name.charAt(length - 2) == '_') {
                --length;
            }
            block3: for (int i = 0; i < length; ++i) {
                char c = this.name.charAt(i);
                if (i == 0 && (c == '%' || c == '_')) {
                    h = 31 * h + 31;
                    continue;
                }
                switch (c) {
                    case '\"': 
                    case '*': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '[': 
                    case ']': 
                    case '_': {
                        continue block3;
                    }
                    default: {
                        h = 31 * h + Character.toLowerCase(c);
                    }
                }
            }
            return h;
        }

        static boolean equals(String name, String other) {
            if (name == other) {
                return true;
            }
            if (name.length() == 0 || other.length() == 0) {
                return false;
            }
            char n = name.charAt(0);
            char o = other.charAt(0);
            if ((o == '%' || o == '_') && n != '%' && n != '_') {
                return false;
            }
            int matchPosition = name.length() - 1;
            for (int i = other.length() - 1; i >= 0; --i) {
                if (matchPosition == -1) {
                    return false;
                }
                o = other.charAt(i);
                n = name.charAt(matchPosition);
                if (!(i != 0 || o != '%' && o != '_' || n != '%' && n != '_')) {
                    return true;
                }
                if (o == '.') {
                    if (n != '.' && n != '-' && n != '_') {
                        return false;
                    }
                } else if (o == '-') {
                    if (n != '.' && n != '_') {
                        return false;
                    }
                } else if (o == '\"') {
                    if (n != '\"' && n != '_') {
                        return false;
                    }
                    if (n == '_' && name.length() - 1 == matchPosition && (matchPosition = name.lastIndexOf("_", matchPosition - 1)) == -1) {
                        return false;
                    }
                } else {
                    if (o == ']') {
                        if (n != ']' && n != '_') {
                            return false;
                        }
                        int beginIndexed = other.lastIndexOf(91, i);
                        if (beginIndexed != -1) {
                            int range = i - beginIndexed - 1;
                            if (name.lastIndexOf(95, matchPosition - 1) == matchPosition - range - 1 && StringUtil.isNumeric((CharSequence)other, (int)(beginIndexed + range), (int)i) && StringUtil.isNumeric((CharSequence)name, (int)(matchPosition - range), (int)matchPosition)) {
                                matchPosition = matchPosition - range - 2;
                                i = i - range - 1;
                                continue;
                            }
                        }
                        return false;
                    }
                    if (o == '_') {
                        if (n != '.' && n != '-' && n != '_' && n != '\"' && n != ']' && n != '[' && n != '/') {
                            return false;
                        }
                        if (n == '\"' && other.length() - 1 == i && (i = other.lastIndexOf("_", i - 1)) == -1) {
                            return false;
                        }
                    } else if (Character.toLowerCase(o) != Character.toLowerCase(n)) {
                        return false;
                    }
                }
                --matchPosition;
            }
            return matchPosition <= 0;
        }
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6812312718645271331L;

        Ser() {
        }

        Object readResolve() {
            return new EnvConfigSource();
        }
    }
}

