/*
 * Decompiled with CFR 0.152.
 */
package io.spring.format.maven;

import io.spring.format.maven.FormatMojo;
import io.spring.javaformat.formatter.Edit;
import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.formatter.FileFormatterException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="apply", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class ApplyMojo
extends FormatMojo {
    @Parameter(property="spring-javaformat.format.skip", defaultValue="false")
    private boolean skip;

    @Override
    protected void execute(List<File> files, Charset encoding, String lineSeparator) throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipGlobally()) {
            this.getLog().debug((CharSequence)"skipping format apply as per configuration.");
            return;
        }
        try {
            this.getFormatter().formatFiles(files, encoding, lineSeparator).filter(Edit::hasEdits).forEach(this::save);
        }
        catch (FileFormatterException ex) {
            throw new MojoExecutionException("Unable to format file " + ex.getFile(), (Exception)((Object)ex));
        }
    }

    private void save(FileEdit edit) {
        this.getLog().debug((CharSequence)("Formatting file " + edit.getFile()));
        edit.save();
    }
}

