/*
 * Decompiled with CFR 0.152.
 */
package io.spring.format.maven;

import io.spring.format.maven.FormatMojo;
import io.spring.javaformat.formatter.Edit;
import io.spring.javaformat.formatter.FileEdit;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ValidateMojo
extends FormatMojo {
    @Parameter(property="spring-javaformat.validate.skip", defaultValue="false")
    private boolean skip;

    @Override
    protected void execute(List<File> files, Charset encoding, String lineSeparator) throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipGlobally()) {
            this.getLog().debug((CharSequence)"skipping format validate as per configuration.");
            return;
        }
        List problems = this.getFormatter().formatFiles(files, encoding, lineSeparator).filter(Edit::hasEdits).map(FileEdit::getFile).collect(Collectors.toList());
        if (!problems.isEmpty()) {
            StringBuilder message = new StringBuilder("Formatting violations found in the following files:\n");
            problems.stream().forEach(f -> message.append(" * " + f + "\n"));
            message.append("\nRun `spring-javaformat:apply` to fix.");
            throw new MojoFailureException(message.toString());
        }
    }
}

