/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.maven.antora;

import java.io.File;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.maven.antora.AntoraYmlUtil;

@Mojo(name="antora-component-version", defaultPhase=LifecyclePhase.VALIDATE)
public class AntoraComponentVersionMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    MavenProject project;

    public void execute() throws MojoExecutionException {
        String version = this.project.getVersion();
        this.project.getProperties().setProperty("antora-component.version", AntoraYmlUtil.componentVersionFromVersion(version));
        this.project.getProperties().setProperty("antora-component.prerelease", AntoraYmlUtil.prereleaseFromVersion(version));
        Resource antoraResource = new Resource();
        antoraResource.setFiltering(true);
        String antoraResources = new File(this.project.getBasedir(), "src/main/antora/resources").getAbsolutePath();
        antoraResource.setDirectory(antoraResources);
        this.project.getResources().add(antoraResource);
    }
}

