/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.client.logging.logback.NacosJoranConfigurator;
import com.alibaba.nacos.common.utils.ResourceUtils;
import org.slf4j.impl.StaticLoggerBinder;

public class LogbackNacosLogging
extends AbstractNacosLogging {
    private static final String NACOS_LOGBACK_LOCATION = "classpath:nacos-logback.xml";

    @Override
    public void loadConfiguration() {
        LoggerContext loggerContext = this.loadConfigurationOnStart();
        if (loggerContext.getObject("RECONFIGURE_ON_CHANGE_TASK") != null) {
            this.addListener(loggerContext);
        }
    }

    private LoggerContext loadConfigurationOnStart() {
        String location = this.getLocation(NACOS_LOGBACK_LOCATION);
        try {
            LoggerContext loggerContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
            NacosJoranConfigurator configurator = new NacosJoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doNacosConfigure(ResourceUtils.getResourceUrl((String)location));
            return loggerContext;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Logback Nacos logging from " + location, e);
        }
    }

    private void addListener(LoggerContext loggerContext) {
        loggerContext.addListener(new LoggerContextListener(){

            public boolean isResetResistant() {
                return true;
            }

            public void onReset(LoggerContext context) {
                LogbackNacosLogging.this.loadConfigurationOnStart();
            }

            public void onStart(LoggerContext context) {
            }

            public void onStop(LoggerContext context) {
            }

            public void onLevelChange(Logger logger, Level level) {
            }
        });
    }
}

