/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.monitor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DistroRecord {
    private final String type;
    private final AtomicLong totalSyncCount;
    private final AtomicLong successfulSyncCount;
    private final AtomicLong failedSyncCount;
    private final AtomicInteger failedVerifyCount;

    public DistroRecord(String type) {
        this.type = type;
        this.totalSyncCount = new AtomicLong();
        this.successfulSyncCount = new AtomicLong();
        this.failedSyncCount = new AtomicLong();
        this.failedVerifyCount = new AtomicInteger();
    }

    public String getType() {
        return this.type;
    }

    public void syncSuccess() {
        this.successfulSyncCount.incrementAndGet();
        this.totalSyncCount.incrementAndGet();
    }

    public void syncFail() {
        this.failedSyncCount.incrementAndGet();
        this.totalSyncCount.incrementAndGet();
    }

    public void verifyFail() {
        this.failedVerifyCount.incrementAndGet();
    }

    public long getTotalSyncCount() {
        return this.totalSyncCount.get();
    }

    public long getSuccessfulSyncCount() {
        return this.successfulSyncCount.get();
    }

    public long getFailedSyncCount() {
        return this.failedSyncCount.get();
    }

    public int getFailedVerifyCount() {
        return this.failedVerifyCount.get();
    }
}

