/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.id;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.consistency.IdGenerator;
import com.alibaba.nacos.core.distributed.id.SnowFlowerIdGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class IdGeneratorManager {
    private final Map<String, IdGenerator> generatorMap = new ConcurrentHashMap<String, IdGenerator>();
    private final Function<String, IdGenerator> supplier = s -> {
        Collection idGenerators = NacosServiceLoader.load(IdGenerator.class);
        Iterator iterator = idGenerators.iterator();
        Object generator = iterator.hasNext() ? (IdGenerator)iterator.next() : new SnowFlowerIdGenerator();
        generator.init();
        return generator;
    };

    public void register(String resource) {
        this.generatorMap.computeIfAbsent(resource, s -> this.supplier.apply(resource));
    }

    public void register(String ... resources) {
        for (String resource : resources) {
            this.generatorMap.computeIfAbsent(resource, s -> this.supplier.apply(resource));
        }
    }

    public long nextId(String resource) {
        if (this.generatorMap.containsKey(resource)) {
            return this.generatorMap.get(resource).nextId();
        }
        throw new NoSuchElementException("The resource is not registered with the distributed ID resource for the time being.");
    }

    public Map<String, IdGenerator> getGeneratorMap() {
        return this.generatorMap;
    }
}

