/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.utils;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum JRaftOps {
    TRANSFER_LEADER("transferLeader"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            PeerId leader;
            Configuration conf = node.getOptions().getInitialConf();
            Status status = cliService.transferLeader(groupId, conf, leader = PeerId.parsePeer((String)args.get("value")));
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    }
    ,
    RESET_RAFT_CLUSTER("restRaftCluster"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            String peerIds;
            Configuration newConf;
            Configuration conf = node.getOptions().getInitialConf();
            Status status = cliService.changePeers(groupId, conf, newConf = JRaftUtils.getConfiguration((String)(peerIds = args.get("value"))));
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    }
    ,
    DO_SNAPSHOT("doSnapshot"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            Configuration conf = node.getOptions().getInitialConf();
            PeerId peerId = PeerId.parsePeer((String)args.get("value"));
            Status status = cliService.snapshot(groupId, peerId);
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    }
    ,
    REMOVE_PEER("removePeer"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            PeerId waitRemove;
            Configuration conf = node.getOptions().getInitialConf();
            List peerIds = cliService.getPeers(groupId, conf);
            if (!peerIds.contains(waitRemove = PeerId.parsePeer((String)args.get("value")))) {
                return RestResultUtils.success();
            }
            Status status = cliService.removePeer(groupId, conf, waitRemove);
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    }
    ,
    REMOVE_PEERS("removePeers"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            Configuration conf = node.getOptions().getInitialConf();
            String peers = args.get("value");
            for (String s : peers.split(",")) {
                Status status;
                PeerId waitRemove;
                List peerIds = cliService.getPeers(groupId, conf);
                if (!peerIds.contains(waitRemove = PeerId.parsePeer((String)s)) || (status = cliService.removePeer(groupId, conf, waitRemove)).isOk()) continue;
                return RestResultUtils.failed((String)status.getErrorMsg());
            }
            return RestResultUtils.success();
        }
    }
    ,
    CHANGE_PEERS("changePeers"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            Configuration conf = node.getOptions().getInitialConf();
            Configuration newConf = new Configuration();
            String peers = args.get("value");
            for (String peer : peers.split(",")) {
                newConf.addPeer(PeerId.parsePeer((String)peer.trim()));
            }
            if (Objects.equals(conf, newConf)) {
                return RestResultUtils.success();
            }
            Status status = cliService.changePeers(groupId, conf, newConf);
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    }
    ,
    RESET_PEERS("resetPeers"){

        @Override
        public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
            Configuration newConf = new Configuration();
            String peers = args.get("value");
            for (String peer : peers.split(",")) {
                newConf.addPeer(PeerId.parsePeer((String)peer.trim()));
            }
            PeerId nodePeerId = node.getNodeId().getPeerId();
            Status status = cliService.resetPeer(groupId, nodePeerId, newConf);
            if (status.isOk()) {
                return RestResultUtils.success();
            }
            return RestResultUtils.failed((String)status.getErrorMsg());
        }
    };

    private String name;

    private JRaftOps(String name) {
        this.name = name;
    }

    public static JRaftOps sourceOf(String command) {
        for (JRaftOps enums : JRaftOps.values()) {
            if (!Objects.equals(command, enums.name)) continue;
            return enums;
        }
        return null;
    }

    public RestResult<String> execute(CliService cliService, String groupId, Node node, Map<String, String> args) {
        return RestResultUtils.success();
    }
}

