/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.api.remote.request.ClientDetectionRequest;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.remote.exception.ConnectionAlreadyClosedException;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.monitor.MetricsMonitor;
import com.alibaba.nacos.core.remote.ClientConnectionEventListenerRegistry;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.event.ConnectionLimitRuleChangeEvent;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionManager
extends Subscriber<ConnectionLimitRuleChangeEvent> {
    public static final String RULE_FILE_NAME = "limitRule";
    private static final long KEEP_ALIVE_TIME = 20000L;
    private ConnectionLimitRule connectionLimitRule = new ConnectionLimitRule();
    private int loadClient = -1;
    String redirectAddress = null;
    private Map<String, AtomicInteger> connectionForClientIp = new ConcurrentHashMap<String, AtomicInteger>(16);
    Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    @Autowired
    private ClientConnectionEventListenerRegistry clientConnectionEventListenerRegistry;

    public ConnectionManager() {
        NotifyCenter.registerToPublisher(ConnectionLimitRuleChangeEvent.class, (int)NotifyCenter.ringBufferSize);
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public boolean traced(String clientIp) {
        return this.connectionLimitRule != null && this.connectionLimitRule.getMonitorIpList() != null && this.connectionLimitRule.getMonitorIpList().contains(clientIp);
    }

    @PostConstruct
    protected void initLimitRue() {
        try {
            this.loadRuleFromLocal();
            this.registerFileWatch();
        }
        catch (Exception e) {
            Loggers.REMOTE.warn("Fail to init limit rue from local ,error= ", (Throwable)e);
        }
    }

    public boolean checkValid(String connectionId) {
        return this.connections.containsKey(connectionId);
    }

    public synchronized boolean register(String connectionId, Connection connection) {
        if (connection.isConnected()) {
            if (this.connections.containsKey(connectionId)) {
                return true;
            }
            if (!this.checkLimit(connection)) {
                return false;
            }
            if (this.traced(connection.getMetaInfo().clientIp)) {
                connection.setTraced(true);
            }
            this.connections.put(connectionId, connection);
            this.connectionForClientIp.get(connection.getMetaInfo().clientIp).getAndIncrement();
            this.clientConnectionEventListenerRegistry.notifyClientConnected(connection);
            Loggers.REMOTE_DIGEST.info("new connection registered successfully, connectionId = {},connection={} ", (Object)connectionId, (Object)connection);
            return true;
        }
        return false;
    }

    private boolean checkLimit(Connection connection) {
        String clientIp = connection.getMetaInfo().clientIp;
        if (connection.getMetaInfo().isClusterSource()) {
            if (!this.connectionForClientIp.containsKey(clientIp)) {
                this.connectionForClientIp.putIfAbsent(clientIp, new AtomicInteger(0));
            }
            return true;
        }
        if (this.isOverLimit()) {
            return false;
        }
        if (!this.connectionForClientIp.containsKey(clientIp)) {
            this.connectionForClientIp.putIfAbsent(clientIp, new AtomicInteger(0));
        }
        AtomicInteger currentCount = this.connectionForClientIp.get(clientIp);
        if (this.connectionLimitRule != null) {
            Integer integerApp;
            Integer integer;
            if (this.connectionLimitRule.getCountLimitPerClientIp().containsKey(clientIp) && (integer = this.connectionLimitRule.getCountLimitPerClientIp().get(clientIp)) != null && integer >= 0) {
                return currentCount.get() < integer;
            }
            String appName = connection.getMetaInfo().getAppName();
            if (StringUtils.isNotBlank((String)appName) && this.connectionLimitRule.getCountLimitPerClientApp().containsKey(appName) && (integerApp = this.connectionLimitRule.getCountLimitPerClientApp().get(appName)) != null && integerApp >= 0) {
                return currentCount.get() < integerApp;
            }
            int countLimitPerClientIpDefault = this.connectionLimitRule.getCountLimitPerClientIpDefault();
            return countLimitPerClientIpDefault <= 0 || currentCount.get() < countLimitPerClientIpDefault;
        }
        return true;
    }

    public synchronized void unregister(String connectionId) {
        Connection remove = this.connections.remove(connectionId);
        if (remove != null) {
            int count;
            String clientIp = remove.getMetaInfo().clientIp;
            AtomicInteger atomicInteger = this.connectionForClientIp.get(clientIp);
            if (atomicInteger != null && (count = atomicInteger.decrementAndGet()) <= 0) {
                this.connectionForClientIp.remove(clientIp);
            }
            remove.close();
            Loggers.REMOTE_DIGEST.info("[{}]Connection unregistered successfully. ", (Object)connectionId);
            this.clientConnectionEventListenerRegistry.notifyClientDisConnected(remove);
        }
    }

    public Connection getConnection(String connectionId) {
        return this.connections.get(connectionId);
    }

    public List<Connection> getConnectionByIp(String clientIp) {
        Set<Map.Entry<String, Connection>> entries = this.connections.entrySet();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Map.Entry<String, Connection> entry : entries) {
            Connection value = entry.getValue();
            if (!clientIp.equals(value.getMetaInfo().clientIp)) continue;
            connections.add(value);
        }
        return connections;
    }

    public int getCurrentConnectionCount() {
        return this.connections.size();
    }

    public void refreshActiveTime(String connectionId) {
        Connection connection = this.connections.get(connectionId);
        if (connection != null) {
            connection.freshActiveTime();
        }
    }

    @PostConstruct
    public void start() {
        RpcScheduledExecutor.COMMON_SERVER_EXECUTOR.scheduleWithFixedDelay(() -> {
            try {
                int totalCount = this.connections.size();
                Loggers.REMOTE_DIGEST.info("Connection check task start");
                MetricsMonitor.getLongConnectionMonitor().set(totalCount);
                Set<Map.Entry<String, Connection>> entries = this.connections.entrySet();
                int currentSdkClientCount = this.currentSdkClientCount();
                boolean isLoaderClient = this.loadClient >= 0;
                int currentMaxClient = isLoaderClient ? this.loadClient : this.connectionLimitRule.countLimit;
                int expelCount = currentMaxClient < 0 ? 0 : Math.max(currentSdkClientCount - currentMaxClient, 0);
                Loggers.REMOTE_DIGEST.info("Total count ={}, sdkCount={},clusterCount={}, currentLimit={}, toExpelCount={}", new Object[]{totalCount, currentSdkClientCount, totalCount - currentSdkClientCount, currentMaxClient + (isLoaderClient ? "(loaderCount)" : ""), expelCount});
                LinkedList<String> expelClient = new LinkedList<String>();
                HashMap<String, AtomicInteger> expelForIp = new HashMap<String, AtomicInteger>(16);
                for (Map.Entry<String, Connection> entry : entries) {
                    AtomicInteger currentCountIp;
                    Connection client = entry.getValue();
                    Iterator<Map.Entry<String, Connection>> appName = client.getMetaInfo().getAppName();
                    String clientIp = client.getMetaInfo().getClientIp();
                    if (!client.getMetaInfo().isSdkSource() || expelForIp.containsKey(clientIp)) continue;
                    int countLimitOfIp = this.connectionLimitRule.getCountLimitOfIp(clientIp);
                    if (countLimitOfIp < 0) {
                        int countLimitOfApp = this.connectionLimitRule.getCountLimitOfApp((String)((Object)appName));
                        int n = countLimitOfIp = countLimitOfApp < 0 ? countLimitOfIp : countLimitOfApp;
                    }
                    if (countLimitOfIp < 0) {
                        countLimitOfIp = this.connectionLimitRule.getCountLimitPerClientIpDefault();
                    }
                    if (countLimitOfIp < 0 || !this.connectionForClientIp.containsKey(clientIp) || (currentCountIp = this.connectionForClientIp.get(clientIp)) == null || currentCountIp.get() <= countLimitOfIp) continue;
                    expelForIp.put(clientIp, new AtomicInteger(currentCountIp.get() - countLimitOfIp));
                }
                Loggers.REMOTE_DIGEST.info("Check over limit for ip limit rule, over limit ip count={}", (Object)expelForIp.size());
                if (expelForIp.size() > 0) {
                    Loggers.REMOTE_DIGEST.info("Over limit ip expel info, {}", expelForIp);
                }
                HashSet<String> outDatedConnections = new HashSet<String>();
                long now = System.currentTimeMillis();
                for (Map.Entry<String, Connection> entry : entries) {
                    Connection client = (Connection)entry.getValue();
                    String clientIp = client.getMetaInfo().getClientIp();
                    AtomicInteger integer = (AtomicInteger)expelForIp.get(clientIp);
                    if (integer != null && integer.intValue() > 0) {
                        integer.decrementAndGet();
                        expelClient.add(client.getMetaInfo().getConnectionId());
                        --expelCount;
                        continue;
                    }
                    if (now - client.getMetaInfo().getLastActiveTime() < 20000L) continue;
                    outDatedConnections.add(client.getMetaInfo().getConnectionId());
                }
                if (expelCount > 0) {
                    for (Map.Entry<String, Connection> entry : entries) {
                        Connection client = entry.getValue();
                        if (expelForIp.containsKey(client.getMetaInfo().clientIp) || !client.getMetaInfo().isSdkSource() || expelCount <= 0) continue;
                        expelClient.add(client.getMetaInfo().getConnectionId());
                        --expelCount;
                        outDatedConnections.remove(client.getMetaInfo().getConnectionId());
                    }
                }
                String serverIp = null;
                String serverPort = null;
                if (StringUtils.isNotBlank((String)this.redirectAddress) && this.redirectAddress.contains(":")) {
                    String[] split = this.redirectAddress.split(":");
                    serverIp = split[0];
                    serverPort = split[1];
                }
                for (String expelledClientId : expelClient) {
                    try {
                        Connection connection = this.getConnection(expelledClientId);
                        if (connection == null) continue;
                        ConnectResetRequest connectResetRequest = new ConnectResetRequest();
                        connectResetRequest.setServerIp(serverIp);
                        connectResetRequest.setServerPort(serverPort);
                        connection.asyncRequest((Request)connectResetRequest, null);
                        Loggers.REMOTE_DIGEST.info("Send connection reset request , connection id = {},recommendServerIp={}, recommendServerPort={}", new Object[]{expelledClientId, connectResetRequest.getServerIp(), connectResetRequest.getServerPort()});
                    }
                    catch (ConnectionAlreadyClosedException e) {
                        this.unregister(expelledClientId);
                    }
                    catch (Exception e) {
                        Loggers.REMOTE_DIGEST.error("Error occurs when expel connection, expelledClientId:{}", (Object)expelledClientId, (Object)e);
                    }
                }
                Loggers.REMOTE_DIGEST.info("Out dated connection ,size={}", (Object)outDatedConnections.size());
                if (CollectionUtils.isNotEmpty(outDatedConnections)) {
                    final HashSet successConnections = new HashSet();
                    final CountDownLatch latch = new CountDownLatch(outDatedConnections.size());
                    for (final String outDateConnectionId : outDatedConnections) {
                        try {
                            final Connection connection = this.getConnection(outDateConnectionId);
                            if (connection != null) {
                                ClientDetectionRequest clientDetectionRequest = new ClientDetectionRequest();
                                connection.asyncRequest((Request)clientDetectionRequest, new RequestCallBack(){

                                    public Executor getExecutor() {
                                        return null;
                                    }

                                    public long getTimeout() {
                                        return 1000L;
                                    }

                                    public void onResponse(Response response) {
                                        latch.countDown();
                                        if (response != null && response.isSuccess()) {
                                            connection.freshActiveTime();
                                            successConnections.add(outDateConnectionId);
                                        }
                                    }

                                    public void onException(Throwable e) {
                                        latch.countDown();
                                    }
                                });
                                Loggers.REMOTE_DIGEST.info("[{}]send connection active request ", (Object)outDateConnectionId);
                                continue;
                            }
                            latch.countDown();
                        }
                        catch (ConnectionAlreadyClosedException e) {
                            latch.countDown();
                        }
                        catch (Exception e) {
                            Loggers.REMOTE_DIGEST.error("[{}]Error occurs when check client active detection ,error={}", (Object)outDateConnectionId, (Object)e);
                            latch.countDown();
                        }
                    }
                    latch.await(3000L, TimeUnit.MILLISECONDS);
                    Loggers.REMOTE_DIGEST.info("Out dated connection check successCount={}", (Object)successConnections.size());
                    for (final String outDateConnectionId : outDatedConnections) {
                        if (successConnections.contains(outDateConnectionId)) continue;
                        Loggers.REMOTE_DIGEST.info("[{}]Unregister Out dated connection....", (Object)outDateConnectionId);
                        this.unregister(outDateConnectionId);
                    }
                }
                if (isLoaderClient) {
                    this.loadClient = -1;
                    this.redirectAddress = null;
                }
                Loggers.REMOTE_DIGEST.info("Connection check task end");
            }
            catch (Throwable e) {
                Loggers.REMOTE.error("Error occurs during connection check... ", e);
            }
        }, 1000L, 3000L, TimeUnit.MILLISECONDS);
    }

    private RequestMeta buildMeta() {
        RequestMeta meta = new RequestMeta();
        meta.setClientVersion(VersionUtils.getFullClientVersion());
        meta.setClientIp(NetUtils.localIP());
        return meta;
    }

    public void loadCount(int loadClient, String redirectAddress) {
        this.loadClient = loadClient;
        this.redirectAddress = redirectAddress;
    }

    public void loadSingle(String connectionId, String redirectAddress) {
        Connection connection = this.getConnection(connectionId);
        if (connection != null && connection.getMetaInfo().isSdkSource()) {
            ConnectResetRequest connectResetRequest = new ConnectResetRequest();
            if (StringUtils.isNotBlank((String)redirectAddress) && redirectAddress.contains(":")) {
                String[] split = redirectAddress.split(":");
                connectResetRequest.setServerIp(split[0]);
                connectResetRequest.setServerPort(split[1]);
            }
            try {
                connection.request((Request)connectResetRequest, 3000L);
            }
            catch (ConnectionAlreadyClosedException e) {
                this.unregister(connectionId);
            }
            catch (Exception e) {
                Loggers.REMOTE.error("error occurs when expel connection, connectionId: {} ", (Object)connectionId, (Object)e);
            }
        }
    }

    public int currentClientsCount() {
        return this.connections.size();
    }

    public int currentClientsCount(Map<String, String> filterLabels) {
        int count = 0;
        for (Connection connection : this.connections.values()) {
            Map<String, String> labels = connection.getMetaInfo().labels;
            boolean disMatchFound = false;
            for (Map.Entry<String, String> entry : filterLabels.entrySet()) {
                if (entry.getValue().equals(labels.get(entry.getKey()))) continue;
                disMatchFound = true;
                break;
            }
            if (disMatchFound) continue;
            ++count;
        }
        return count;
    }

    public int currentSdkClientCount() {
        HashMap<String, String> filter = new HashMap<String, String>(2);
        filter.put("source", "sdk");
        return this.currentClientsCount(filter);
    }

    public Map<String, Connection> currentClients() {
        return this.connections;
    }

    private boolean isOverLimit() {
        return this.connectionLimitRule.countLimit > 0 && this.currentSdkClientCount() >= this.connectionLimitRule.getCountLimit();
    }

    public void onEvent(ConnectionLimitRuleChangeEvent event) {
        String limitRule = event.getLimitRule();
        Loggers.REMOTE.info("connection limit rule change event receive :{}", (Object)limitRule);
        try {
            ConnectionLimitRule connectionLimitRule = (ConnectionLimitRule)JacksonUtils.toObj((String)limitRule, ConnectionLimitRule.class);
            if (connectionLimitRule != null) {
                this.connectionLimitRule = connectionLimitRule;
                try {
                    this.saveRuleToLocal(this.connectionLimitRule);
                }
                catch (Exception e) {
                    Loggers.REMOTE.warn("Fail to save rule to local error is ", (Throwable)e);
                }
            } else {
                Loggers.REMOTE.info("Parse rule is null,Ignore illegal rule  :{}", (Object)limitRule);
            }
        }
        catch (Exception e) {
            Loggers.REMOTE.error("Fail to parse connection limit rule :{}", (Object)limitRule, (Object)e);
        }
    }

    public Class<? extends Event> subscribeType() {
        return ConnectionLimitRuleChangeEvent.class;
    }

    public ConnectionLimitRule getConnectionLimitRule() {
        return this.connectionLimitRule;
    }

    private synchronized void loadRuleFromLocal() throws Exception {
        String ruleContent;
        ConnectionLimitRule connectionLimitRule;
        File limitFile = this.getRuleFile();
        if (!limitFile.exists()) {
            limitFile.createNewFile();
        }
        ConnectionLimitRule connectionLimitRule2 = connectionLimitRule = StringUtils.isBlank((CharSequence)(ruleContent = DiskUtils.readFile((File)limitFile))) ? new ConnectionLimitRule() : (ConnectionLimitRule)JacksonUtils.toObj((String)ruleContent, ConnectionLimitRule.class);
        if (connectionLimitRule != null) {
            this.connectionLimitRule = connectionLimitRule;
            Set monitorIpList = connectionLimitRule.monitorIpList;
            for (Connection connection : this.connections.values()) {
                String clientIp = connection.getMetaInfo().getClientIp();
                if (!CollectionUtils.isEmpty((Collection)monitorIpList) && monitorIpList.contains(clientIp)) {
                    connection.setTraced(true);
                    continue;
                }
                connection.setTraced(false);
            }
        }
        Loggers.REMOTE.info("Init loader limit rule from local,rule={}", (Object)ruleContent);
    }

    private synchronized void saveRuleToLocal(ConnectionLimitRule limitRule) throws IOException {
        File limitFile = this.getRuleFile();
        if (!limitFile.exists()) {
            limitFile.createNewFile();
        }
        DiskUtils.writeFile((File)limitFile, (byte[])JacksonUtils.toJson((Object)limitRule).getBytes("UTF-8"), (boolean)false);
    }

    private File getRuleFile() {
        File baseDir = new File(EnvUtil.getNacosHome(), "data" + File.separator + "loader" + File.separator);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        return new File(baseDir, RULE_FILE_NAME);
    }

    private void registerFileWatch() {
        try {
            String tpsPath = Paths.get(EnvUtil.getNacosHome(), "data", "loader").toString();
            WatchFileCenter.registerWatcher((String)tpsPath, (FileWatcher)new FileWatcher(){

                public void onChange(FileChangeEvent event) {
                    try {
                        String fileName = event.getContext().toString();
                        if (ConnectionManager.RULE_FILE_NAME.equals(fileName)) {
                            ConnectionManager.this.loadRuleFromLocal();
                        }
                    }
                    catch (Throwable throwable) {
                        Loggers.REMOTE.warn("Fail to load rule from local", throwable);
                    }
                }

                public boolean interest(String context) {
                    return ConnectionManager.RULE_FILE_NAME.equals(context);
                }
            });
        }
        catch (NacosException e) {
            Loggers.REMOTE.warn("Register  connection rule fail ", (Throwable)e);
        }
    }

    static class ConnectionLimitRule {
        private Set<String> monitorIpList = new HashSet<String>();
        private int countLimit = -1;
        private int countLimitPerClientIpDefault = -1;
        private Map<String, Integer> countLimitPerClientIp = new HashMap<String, Integer>();
        private Map<String, Integer> countLimitPerClientApp = new HashMap<String, Integer>();

        ConnectionLimitRule() {
        }

        public int getCountLimit() {
            return this.countLimit;
        }

        public void setCountLimit(int countLimit) {
            this.countLimit = countLimit;
        }

        public int getCountLimitPerClientIpDefault() {
            return this.countLimitPerClientIpDefault;
        }

        public void setCountLimitPerClientIpDefault(int countLimitPerClientIpDefault) {
            this.countLimitPerClientIpDefault = countLimitPerClientIpDefault;
        }

        public int getCountLimitOfIp(String clientIp) {
            Integer integer;
            if (this.countLimitPerClientIp.containsKey(clientIp) && (integer = this.countLimitPerClientIp.get(clientIp)) != null && integer >= 0) {
                return integer;
            }
            return -1;
        }

        public int getCountLimitOfApp(String appName) {
            Integer integer;
            if (this.countLimitPerClientApp.containsKey(appName) && (integer = this.countLimitPerClientApp.get(appName)) != null && integer >= 0) {
                return integer;
            }
            return -1;
        }

        public Map<String, Integer> getCountLimitPerClientIp() {
            return this.countLimitPerClientIp;
        }

        public void setCountLimitPerClientIp(Map<String, Integer> countLimitPerClientIp) {
            this.countLimitPerClientIp = countLimitPerClientIp;
        }

        public Map<String, Integer> getCountLimitPerClientApp() {
            return this.countLimitPerClientApp;
        }

        public void setCountLimitPerClientApp(Map<String, Integer> countLimitPerClientApp) {
            this.countLimitPerClientApp = countLimitPerClientApp;
        }

        public Set<String> getMonitorIpList() {
            return this.monitorIpList;
        }

        public void setMonitorIpList(Set<String> monitorIpList) {
            this.monitorIpList = monitorIpList;
        }
    }
}

