/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.AbstractRequestCallBack;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.ServerRequest;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.exception.ConnectionAlreadyClosedException;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RpcPushService {
    @Autowired
    private ConnectionManager connectionManager;

    public void pushWithCallback(String connectionId, ServerRequest request, final PushCallBack requestCallBack, final Executor executor) {
        Connection connection = this.connectionManager.getConnection(connectionId);
        if (connection != null) {
            try {
                connection.asyncRequest((Request)request, (RequestCallBack)new AbstractRequestCallBack(requestCallBack.getTimeout()){

                    public Executor getExecutor() {
                        return executor;
                    }

                    public void onResponse(Response response) {
                        if (response.isSuccess()) {
                            requestCallBack.onSuccess();
                        } else {
                            requestCallBack.onFail((Throwable)new NacosException(response.getErrorCode(), response.getMessage()));
                        }
                    }

                    public void onException(Throwable e) {
                        requestCallBack.onFail(e);
                    }
                });
            }
            catch (ConnectionAlreadyClosedException e) {
                this.connectionManager.unregister(connectionId);
                requestCallBack.onSuccess();
            }
            catch (Exception e) {
                Loggers.REMOTE_DIGEST.error("error to send push response to connectionId ={},push response={}", new Object[]{connectionId, request, e});
                requestCallBack.onFail((Throwable)e);
            }
        } else {
            requestCallBack.onSuccess();
        }
    }

    public void pushWithoutAck(String connectionId, ServerRequest request) {
        Connection connection = this.connectionManager.getConnection(connectionId);
        if (connection != null) {
            try {
                connection.request((Request)request, 3000L);
            }
            catch (ConnectionAlreadyClosedException e) {
                this.connectionManager.unregister(connectionId);
            }
            catch (Exception e) {
                Loggers.REMOTE_DIGEST.error("error to send push response to connectionId ={},push response={}", new Object[]{connectionId, request, e});
            }
        }
    }
}

