/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.code;

import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;

public class StandaloneProfileApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneProfileApplicationListener.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (((Boolean)environment.getProperty("nacos.standalone", Boolean.TYPE, (Object)false)).booleanValue()) {
            environment.addActiveProfile("standalone");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Spring Environment's active profiles : {} in standalone mode : {}", Arrays.asList(environment.getActiveProfiles()), (Object)EnvUtil.getStandaloneMode());
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

