/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control.http;

import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.control.http.HttpTpsCheckRequestParser;
import com.alibaba.nacos.core.control.http.HttpTpsCheckRequestParserRegistry;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class NacosHttpTpsControlInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            Method method;
            if (handler instanceof HandlerMethod && (method = ((HandlerMethod)handler).getMethod()).isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
                TpsControl tpsControl = method.getAnnotation(TpsControl.class);
                String pointName = tpsControl.pointName();
                HttpTpsCheckRequestParser parser = HttpTpsCheckRequestParserRegistry.getParser(pointName);
                TpsCheckRequest httpTpsCheckRequest = null;
                if (parser != null) {
                    httpTpsCheckRequest = parser.parse(request);
                }
                if (httpTpsCheckRequest == null) {
                    httpTpsCheckRequest = new TpsCheckRequest();
                }
                httpTpsCheckRequest.setPointName(pointName);
                TpsCheckResponse checkResponse = ControlManagerCenter.getInstance().getTpsControlManager().check(httpTpsCheckRequest);
                if (!checkResponse.isSuccess()) {
                    this.generate503Response(request, response, checkResponse.getMessage());
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Loggers.TPS.error("Error to check tps control", throwable);
        }
        return true;
    }

    void generate503Response(HttpServletRequest request, HttpServletResponse response, String message) {
        try {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-cache,no-store");
            response.setStatus(503);
            response.getWriter().println(message);
        }
        catch (Exception ex) {
            Loggers.TPS.error("Error to generate tps 503 response", (Throwable)ex);
        }
    }
}

