/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.request.ServerLoaderInfoRequest;
import com.alibaba.nacos.api.remote.request.ServerReloadRequest;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ServerLoaderInfoResponse;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.remote.ClusterRpcClientProxy;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.core.ServerLoaderInfoRequestHandler;
import com.alibaba.nacos.core.remote.core.ServerReloaderRequestHandler;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/core/loader"})
public class ServerLoaderController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLoaderController.class);
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_FOR_SPLIT_SYMBOL = ",";
    private static final String SUCCESS_RESULT = "Ok";
    private static final String FAIL_RESULT = "Fail";
    private static final String SDK_CONNECTION_COUNT_METRIC = "sdkConCount";
    private final ConnectionManager connectionManager;
    private final ServerMemberManager serverMemberManager;
    private final ClusterRpcClientProxy clusterRpcClientProxy;
    private final ServerReloaderRequestHandler serverReloaderRequestHandler;
    private final ServerLoaderInfoRequestHandler serverLoaderInfoRequestHandler;

    public ServerLoaderController(ConnectionManager connectionManager, ServerMemberManager serverMemberManager, ClusterRpcClientProxy clusterRpcClientProxy, ServerReloaderRequestHandler serverReloaderRequestHandler, ServerLoaderInfoRequestHandler serverLoaderInfoRequestHandler) {
        this.connectionManager = connectionManager;
        this.serverMemberManager = serverMemberManager;
        this.clusterRpcClientProxy = clusterRpcClientProxy;
        this.serverReloaderRequestHandler = serverReloaderRequestHandler;
        this.serverLoaderInfoRequestHandler = serverLoaderInfoRequestHandler;
    }

    @Secured(resource="/v2/core/loader", action=ActionTypes.READ)
    @GetMapping(value={"/current"})
    public ResponseEntity<Map<String, Connection>> currentClients() {
        Map<String, Connection> stringConnectionMap = this.connectionManager.currentClients();
        return ResponseEntity.ok().body(stringConnectionMap);
    }

    @Secured(resource="/v2/core/loader", action=ActionTypes.WRITE)
    @GetMapping(value={"/reloadCurrent"})
    public ResponseEntity<String> reloadCount(@RequestParam Integer count, @RequestParam(value="redirectAddress", required=false) String redirectAddress) {
        this.connectionManager.loadCount(count, redirectAddress);
        return ResponseEntity.ok().body((Object)"success");
    }

    @Secured(resource="/v2/core/loader", action=ActionTypes.WRITE)
    @GetMapping(value={"/smartReloadCluster"})
    public ResponseEntity<String> smartReload(HttpServletRequest request, @RequestParam(value="loaderFactor", required=false) String loaderFactorStr, @RequestParam(value="force", required=false) String force) {
        LOGGER.info("Smart reload request receive,requestIp={}", (Object)ServerLoaderController.getRemoteIp(request));
        Map<String, Object> serverLoadMetrics = this.getServerLoadMetrics();
        Object avgString = serverLoadMetrics.get("avg");
        List details = (List)serverLoadMetrics.get("detail");
        int avg = Integer.parseInt(avgString.toString());
        float loaderFactor = StringUtils.isBlank((CharSequence)loaderFactorStr) ? 0.1f : Float.parseFloat(loaderFactorStr);
        int overLimitCount = (int)((float)avg * (1.0f + loaderFactor));
        int lowLimitCount = (int)((float)avg * (1.0f - loaderFactor));
        ArrayList<ServerLoaderMetrics> overLimitServer = new ArrayList<ServerLoaderMetrics>();
        ArrayList<ServerLoaderMetrics> lowLimitServer = new ArrayList<ServerLoaderMetrics>();
        for (ServerLoaderMetrics metrics : details) {
            int sdkCount = Integer.parseInt(metrics.getMetric().get(SDK_CONNECTION_COUNT_METRIC));
            if (sdkCount > overLimitCount) {
                overLimitServer.add(metrics);
            }
            if (sdkCount >= lowLimitCount) continue;
            lowLimitServer.add(metrics);
        }
        overLimitServer.sort((o1, o2) -> {
            Integer sdkCount1 = Integer.valueOf(o1.getMetric().get(SDK_CONNECTION_COUNT_METRIC));
            Integer sdkCount2 = Integer.valueOf(o2.getMetric().get(SDK_CONNECTION_COUNT_METRIC));
            return sdkCount1.compareTo(sdkCount2) * -1;
        });
        LOGGER.info("Over load limit server list ={}", overLimitServer);
        lowLimitServer.sort((o1, o2) -> {
            Integer sdkCount1 = Integer.valueOf(o1.getMetric().get(SDK_CONNECTION_COUNT_METRIC));
            Integer sdkCount2 = Integer.valueOf(o2.getMetric().get(SDK_CONNECTION_COUNT_METRIC));
            return sdkCount1.compareTo(sdkCount2);
        });
        LOGGER.info("Low load limit server list ={}", lowLimitServer);
        final AtomicBoolean result = new AtomicBoolean(true);
        int i = 0;
        while (i < overLimitServer.size() & i < lowLimitServer.size()) {
            ServerReloadRequest serverLoaderInfoRequest = new ServerReloadRequest();
            serverLoaderInfoRequest.setReloadCount(overLimitCount);
            serverLoaderInfoRequest.setReloadServer(((ServerLoaderMetrics)lowLimitServer.get((int)i)).address);
            final Member member = this.serverMemberManager.find(((ServerLoaderMetrics)overLimitServer.get((int)i)).address);
            LOGGER.info("Reload task submit ,fromServer ={},toServer={}, ", (Object)((ServerLoaderMetrics)overLimitServer.get((int)i)).address, (Object)((ServerLoaderMetrics)lowLimitServer.get((int)i)).address);
            if (this.serverMemberManager.getSelf().equals(member)) {
                try {
                    this.serverReloaderRequestHandler.handle(serverLoaderInfoRequest, new RequestMeta());
                }
                catch (NacosException e) {
                    LOGGER.error("Fail to loader self server", (Throwable)e);
                    result.set(false);
                }
            } else {
                try {
                    this.clusterRpcClientProxy.asyncRequest(member, (Request)serverLoaderInfoRequest, new RequestCallBack(){

                        public Executor getExecutor() {
                            return null;
                        }

                        public long getTimeout() {
                            return 100L;
                        }

                        public void onResponse(Response response) {
                            if (response == null || !response.isSuccess()) {
                                LOGGER.error("Fail to loader member={},response={}", (Object)member.getAddress(), (Object)response);
                                result.set(false);
                            }
                        }

                        public void onException(Throwable e) {
                            LOGGER.error("Fail to loader member={}", (Object)member.getAddress(), (Object)e);
                            result.set(false);
                        }
                    });
                }
                catch (NacosException e) {
                    LOGGER.error("Fail to loader member={}", (Object)member.getAddress(), (Object)e);
                    result.set(false);
                }
            }
            ++i;
        }
        return ResponseEntity.ok().body((Object)(result.get() ? SUCCESS_RESULT : FAIL_RESULT));
    }

    @Secured(resource="/v2/core/loader", action=ActionTypes.WRITE)
    @GetMapping(value={"/reloadClient"})
    public ResponseEntity<String> reloadSingle(@RequestParam String connectionId, @RequestParam(value="redirectAddress", required=false) String redirectAddress) {
        this.connectionManager.loadSingle(connectionId, redirectAddress);
        return ResponseEntity.ok().body((Object)"success");
    }

    @Secured(resource="/v2/core/loader", action=ActionTypes.READ)
    @GetMapping(value={"/cluster"})
    public ResponseEntity<Map<String, Object>> loaderMetrics() {
        Map<String, Object> serverLoadMetrics = this.getServerLoadMetrics();
        return ResponseEntity.ok().body(serverLoadMetrics);
    }

    private Map<String, Object> getServerLoadMetrics() {
        final LinkedList<ServerLoaderMetrics> responseList = new LinkedList<ServerLoaderMetrics>();
        int memberSize = this.serverMemberManager.allMembersWithoutSelf().size();
        final CountDownLatch countDownLatch = new CountDownLatch(memberSize);
        for (final Member member : this.serverMemberManager.allMembersWithoutSelf()) {
            if (MemberUtil.isSupportedLongCon(member)) {
                ServerLoaderInfoRequest serverLoaderInfoRequest = new ServerLoaderInfoRequest();
                try {
                    this.clusterRpcClientProxy.asyncRequest(member, (Request)serverLoaderInfoRequest, new RequestCallBack(){

                        public Executor getExecutor() {
                            return null;
                        }

                        public long getTimeout() {
                            return 200L;
                        }

                        public void onResponse(Response response) {
                            if (response instanceof ServerLoaderInfoResponse) {
                                ServerLoaderMetrics metrics = new ServerLoaderMetrics();
                                metrics.setAddress(member.getAddress());
                                metrics.setMetric(((ServerLoaderInfoResponse)response).getLoaderMetrics());
                                responseList.add(metrics);
                            }
                            countDownLatch.countDown();
                        }

                        public void onException(Throwable e) {
                            LOGGER.error("Get metrics fail,member={}", (Object)member.getAddress(), (Object)e);
                            countDownLatch.countDown();
                        }
                    });
                }
                catch (NacosException e) {
                    LOGGER.error("Get metrics fail,member={}", (Object)member.getAddress(), (Object)e);
                    countDownLatch.countDown();
                }
                continue;
            }
            countDownLatch.countDown();
        }
        try {
            ServerLoaderInfoResponse handle = this.serverLoaderInfoRequestHandler.handle(new ServerLoaderInfoRequest(), new RequestMeta());
            ServerLoaderMetrics metrics = new ServerLoaderMetrics();
            metrics.setAddress(this.serverMemberManager.getSelf().getAddress());
            metrics.setMetric(handle.getLoaderMetrics());
            responseList.add(metrics);
        }
        catch (NacosException e) {
            LOGGER.error("Get self metrics fail", (Throwable)e);
        }
        try {
            countDownLatch.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Get  metrics timeout,metrics info may not complete.");
        }
        int max = 0;
        int min = -1;
        int total = 0;
        for (ServerLoaderMetrics serverLoaderMetrics : responseList) {
            String sdkConCountStr = serverLoaderMetrics.getMetric().get(SDK_CONNECTION_COUNT_METRIC);
            if (!StringUtils.isNotBlank((String)sdkConCountStr)) continue;
            int sdkConCount = Integer.parseInt(sdkConCountStr);
            if (max == 0 || max < sdkConCount) {
                max = sdkConCount;
            }
            if (min == -1 || sdkConCount < min) {
                min = sdkConCount;
            }
            total += sdkConCount;
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>(9);
        responseList.sort(Comparator.comparing(ServerLoaderMetrics::getAddress));
        responseMap.put("detail", responseList);
        responseMap.put("memberCount", this.serverMemberManager.allMembers().size());
        responseMap.put("metricsCount", responseList.size());
        responseMap.put("completed", responseList.size() == this.serverMemberManager.allMembers().size());
        responseMap.put("max", max);
        responseMap.put("min", min);
        responseMap.put("avg", total / responseList.size());
        responseMap.put("threshold", (double)(total / responseList.size()) * 1.1);
        responseMap.put("total", total);
        return responseMap;
    }

    private static String getRemoteIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR);
        if (!StringUtils.isBlank((CharSequence)xForwardedFor)) {
            return xForwardedFor.split(X_FORWARDED_FOR_SPLIT_SYMBOL)[0].trim();
        }
        String nginxHeader = request.getHeader(X_REAL_IP);
        return StringUtils.isBlank((CharSequence)nginxHeader) ? request.getRemoteAddr() : nginxHeader;
    }

    class ServerLoaderMetrics {
        String address;
        Map<String, String> metric = new HashMap<String, String>();

        ServerLoaderMetrics() {
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Map<String, String> getMetric() {
            return this.metric;
        }

        public void setMetric(Map<String, String> metric) {
            this.metric = metric;
        }
    }
}

