/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.model.request.LookupUpdateRequest;
import com.alibaba.nacos.core.service.NacosClusterOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/core/cluster"})
public class NacosClusterControllerV2 {
    private final NacosClusterOperationService nacosClusterOperationService;

    public NacosClusterControllerV2(NacosClusterOperationService nacosClusterOperationService) {
        this.nacosClusterOperationService = nacosClusterOperationService;
    }

    @GetMapping(value={"/node/self"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin", signType="console")
    public Result<Member> self() {
        return Result.success((Object)this.nacosClusterOperationService.self());
    }

    @GetMapping(value={"/node/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin", signType="console")
    public Result<Collection<Member>> listNodes(@RequestParam(value="address", required=false) String address, @RequestParam(value="state", required=false) String state) throws NacosException {
        NodeState nodeState = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{state})) {
            try {
                nodeState = NodeState.valueOf(state.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_STATE, "Illegal state: " + state);
            }
        }
        return Result.success(this.nacosClusterOperationService.listNodes(address, nodeState));
    }

    @GetMapping(value={"/node/self/health"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin", signType="console")
    public Result<String> selfHealth() {
        return Result.success((Object)this.nacosClusterOperationService.selfHealth());
    }

    @PutMapping(value={"/node/list"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    public Result<Boolean> updateNodes(@RequestBody List<Member> nodes) throws NacosApiException {
        if (nodes == null || nodes.size() == 0) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "required parameter 'nodes' is missing");
        }
        return Result.success((Object)this.nacosClusterOperationService.updateNodes(nodes));
    }

    @PutMapping(value={"/lookup"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    public Result<Boolean> updateLookup(LookupUpdateRequest request) throws NacosException {
        if (request == null || request.getType() == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "required parameter 'type' is missing");
        }
        return Result.success((Object)this.nacosClusterOperationService.updateLookup(request));
    }

    @DeleteMapping(value={"/nodes"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    public RestResult<Void> deleteNodes(@RequestParam(value="addresses") List<String> addresses) throws Exception {
        return RestResultUtils.failed((int)405, null, (String)"DELETE /v2/core/cluster/nodes API not allow to use temporarily.");
    }
}

