/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.component;

import com.alibaba.nacos.core.distributed.distro.component.DistroDataProcessor;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataStorage;
import com.alibaba.nacos.core.distributed.distro.component.DistroFailedTaskHandler;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DistroComponentHolder {
    private final Map<String, DistroTransportAgent> transportAgentMap = new HashMap<String, DistroTransportAgent>();
    private final Map<String, DistroDataStorage> dataStorageMap = new HashMap<String, DistroDataStorage>();
    private final Map<String, DistroFailedTaskHandler> failedTaskHandlerMap = new HashMap<String, DistroFailedTaskHandler>();
    private final Map<String, DistroDataProcessor> dataProcessorMap = new HashMap<String, DistroDataProcessor>();

    public DistroTransportAgent findTransportAgent(String type) {
        return this.transportAgentMap.get(type);
    }

    public void registerTransportAgent(String type, DistroTransportAgent transportAgent) {
        this.transportAgentMap.put(type, transportAgent);
    }

    public DistroDataStorage findDataStorage(String type) {
        return this.dataStorageMap.get(type);
    }

    public void registerDataStorage(String type, DistroDataStorage dataStorage) {
        this.dataStorageMap.put(type, dataStorage);
    }

    public Set<String> getDataStorageTypes() {
        return this.dataStorageMap.keySet();
    }

    public DistroFailedTaskHandler findFailedTaskHandler(String type) {
        return this.failedTaskHandlerMap.get(type);
    }

    public void registerFailedTaskHandler(String type, DistroFailedTaskHandler failedTaskHandler) {
        this.failedTaskHandlerMap.put(type, failedTaskHandler);
    }

    public void registerDataProcessor(DistroDataProcessor dataProcessor) {
        this.dataProcessorMap.putIfAbsent(dataProcessor.processType(), dataProcessor);
    }

    public DistroDataProcessor findDataProcessor(String processType) {
        return this.dataProcessorMap.get(processType);
    }
}

