/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.utils;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.RaftConfig;
import com.alibaba.nacos.core.utils.ClassUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class RaftExecutor {
    private static ExecutorService raftCoreExecutor;
    private static ExecutorService raftCliServiceExecutor;
    private static ScheduledExecutorService raftCommonExecutor;
    private static ExecutorService raftSnapshotExecutor;
    private static final String OWNER;

    private RaftExecutor() {
    }

    public static void init(RaftConfig config) {
        int raftCoreThreadNum = Integer.parseInt(config.getValOfDefault("core_thread_num", "8"));
        int raftCliServiceThreadNum = Integer.parseInt(config.getValOfDefault("cli_service_thread_num", "4"));
        raftCoreExecutor = ExecutorFactory.Managed.newFixedExecutorService((String)OWNER, (int)raftCoreThreadNum, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.core.raft-core"));
        raftCliServiceExecutor = ExecutorFactory.Managed.newFixedExecutorService((String)OWNER, (int)raftCliServiceThreadNum, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.core.raft-cli-service"));
        raftCommonExecutor = ExecutorFactory.Managed.newScheduledExecutorService((String)OWNER, (int)8, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.core.protocol.raft-common"));
        int snapshotNum = raftCoreThreadNum / 2;
        snapshotNum = snapshotNum == 0 ? raftCoreThreadNum : snapshotNum;
        raftSnapshotExecutor = ExecutorFactory.Managed.newFixedExecutorService((String)OWNER, (int)snapshotNum, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.core.raft-snapshot"));
    }

    public static void scheduleRaftMemberRefreshJob(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        raftCommonExecutor.scheduleAtFixedRate(runnable, initialDelay, period, unit);
    }

    public static ExecutorService getRaftCoreExecutor() {
        return raftCoreExecutor;
    }

    public static ExecutorService getRaftCliServiceExecutor() {
        return raftCliServiceExecutor;
    }

    public static void executeByCommon(Runnable r) {
        raftCommonExecutor.execute(r);
    }

    public static void scheduleByCommon(Runnable r, long delayMs) {
        raftCommonExecutor.schedule(r, delayMs, TimeUnit.MILLISECONDS);
    }

    public static void scheduleAtFixedRateByCommon(Runnable command, long initialDelayMs, long periodMs) {
        raftCommonExecutor.scheduleAtFixedRate(command, initialDelayMs, periodMs, TimeUnit.MILLISECONDS);
    }

    public static ScheduledExecutorService getRaftCommonExecutor() {
        return raftCommonExecutor;
    }

    public static void doSnapshot(Runnable runnable) {
        raftSnapshotExecutor.execute(runnable);
    }

    static {
        OWNER = ClassUtils.getCanonicalName(JRaftServer.class);
    }
}

