/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.utils.LoggerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class TimerContext {
    private static final ThreadLocal<Map<String, Long>> TIME_RECORD = ThreadLocal.withInitial(() -> new HashMap(2));

    public static void start(String name) {
        TIME_RECORD.get().put(name, System.currentTimeMillis());
    }

    public static void end(String name, Logger logger) {
        TimerContext.end(name, logger, "DEBUG");
    }

    public static void end(String name, Logger logger, String level) {
        Map<String, Long> record = TIME_RECORD.get();
        long contextTime = System.currentTimeMillis() - record.remove(name);
        if (record.isEmpty()) {
            TIME_RECORD.remove();
        }
        switch (level) {
            case "DEBUG": {
                LoggerUtils.printIfDebugEnabled((Logger)logger, (String)"{} cost time : {} ms", (Object[])new Object[]{name, contextTime});
                break;
            }
            case "INFO": {
                LoggerUtils.printIfInfoEnabled((Logger)logger, (String)"{} cost time : {} ms", (Object[])new Object[]{name, contextTime});
                break;
            }
            case "TRACE": {
                LoggerUtils.printIfTraceEnabled((Logger)logger, (String)"{} cost time : {} ms", (Object[])new Object[]{name, contextTime});
                break;
            }
            case "ERROR": {
                LoggerUtils.printIfErrorEnabled((Logger)logger, (String)"{} cost time : {} ms", (Object[])new Object[]{name, contextTime});
                break;
            }
            case "WARN": {
                LoggerUtils.printIfWarnEnabled((Logger)logger, (String)"{} cost time : {} ms", (Object[])new Object[]{name, contextTime});
                break;
            }
            default: {
                LoggerUtils.printIfErrorEnabled((Logger)logger, (String)"level not found , {} cost time : {} ms", (Object[])new Object[]{name, contextTime});
            }
        }
    }

    public static void run(Runnable job, String name, Logger logger) {
        TimerContext.start(name);
        try {
            job.run();
        }
        finally {
            TimerContext.end(name, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V run(Supplier<V> job, String name, Logger logger) {
        TimerContext.start(name);
        try {
            V v = job.get();
            return v;
        }
        finally {
            TimerContext.end(name, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R run(Function<T, R> job, T args, String name, Logger logger) {
        TimerContext.start(name);
        try {
            R r = job.apply(args);
            return r;
        }
        finally {
            TimerContext.end(name, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void run(Consumer<T> job, T args, String name, Logger logger) {
        TimerContext.start(name);
        try {
            job.accept(args);
        }
        finally {
            TimerContext.end(name, logger);
        }
    }
}

