/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusManager {
    @Resource(name="consistencyDelegate")
    private ConsistencyService consistencyService;
    private final SwitchDomain switchDomain;
    private ServerStatus serverStatus = ServerStatus.STARTING;

    public ServerStatusManager(SwitchDomain switchDomain) {
        this.switchDomain = switchDomain;
    }

    @PostConstruct
    public void init() {
        GlobalExecutor.registerServerStatusUpdater(new ServerStatusUpdater());
    }

    private void refreshServerStatus() {
        if (StringUtils.isNotBlank((String)this.switchDomain.getOverriddenServerStatus())) {
            this.serverStatus = ServerStatus.valueOf(this.switchDomain.getOverriddenServerStatus());
            return;
        }
        this.serverStatus = this.consistencyService.isAvailable() ? ServerStatus.UP : ServerStatus.DOWN;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public Optional<String> getErrorMsg() {
        return this.consistencyService.getErrorMsg();
    }

    public class ServerStatusUpdater
    implements Runnable {
        @Override
        public void run() {
            ServerStatusManager.this.refreshServerStatus();
        }
    }
}

