/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteAction;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV2Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;

public class DoubleWriteServiceRemovalToV1Task
extends AbstractExecuteTask {
    private final com.alibaba.nacos.naming.core.v2.pojo.Service service;

    public DoubleWriteServiceRemovalToV1Task(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        this.service = service;
    }

    public void run() {
        try {
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            Service serviceV1 = serviceManager.getService(this.service.getNamespace(), this.service.getGroupedServiceName());
            if (serviceV1 == null) {
                if (Loggers.SRV_LOG.isDebugEnabled()) {
                    Loggers.SRV_LOG.debug("Double write task is removing a non-exist service: {}", (Object)this.service);
                }
                return;
            }
            ConsistencyService consistencyService = (ConsistencyService)ApplicationUtils.getBean((String)"consistencyDelegate", ConsistencyService.class);
            String instanceListKey = KeyBuilder.buildInstanceListKey(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral());
            consistencyService.remove(instanceListKey);
            serviceManager.easyRemoveService(this.service.getNamespace(), this.service.getGroupedServiceName());
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write task for removal of {} from 2 to 1 failed", (Object)this.service, (Object)e);
            }
            ServiceChangeV2Task retryTask = new ServiceChangeV2Task(this.service, DoubleWriteContent.BOTH, DoubleWriteAction.REMOVE);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV2Task.getKey(this.service);
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }
}

