/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component(value="distroMapper")
public class DistroMapper
extends MemberChangeListener {
    private volatile List<String> healthyList = new ArrayList<String>();
    private final SwitchDomain switchDomain;
    private final ServerMemberManager memberManager;

    public DistroMapper(ServerMemberManager memberManager, SwitchDomain switchDomain) {
        this.memberManager = memberManager;
        this.switchDomain = switchDomain;
    }

    public List<String> getHealthyList() {
        return this.healthyList;
    }

    @PostConstruct
    public void init() {
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.healthyList = MemberUtil.simpleMembers((Collection)this.memberManager.allMembers());
    }

    public boolean responsible(Cluster cluster, Instance instance) {
        return this.switchDomain.isHealthCheckEnabled(cluster.getServiceName()) && !cluster.getHealthCheckTask().isCancelled() && this.responsible(cluster.getServiceName()) && cluster.contains(instance);
    }

    public boolean responsible(String responsibleTag) {
        List<String> servers = this.healthyList;
        if (!this.switchDomain.isDistroEnabled() || EnvUtil.getStandaloneMode()) {
            return true;
        }
        if (CollectionUtils.isEmpty(servers)) {
            return false;
        }
        String localAddress = EnvUtil.getLocalAddress();
        int index = servers.indexOf(localAddress);
        int lastIndex = servers.lastIndexOf(localAddress);
        if (lastIndex < 0 || index < 0) {
            return true;
        }
        int target = this.distroHash(responsibleTag) % servers.size();
        return target >= index && target <= lastIndex;
    }

    public String mapSrv(String responsibleTag) {
        List<String> servers = this.healthyList;
        if (CollectionUtils.isEmpty(servers) || !this.switchDomain.isDistroEnabled()) {
            return EnvUtil.getLocalAddress();
        }
        try {
            int index = this.distroHash(responsibleTag) % servers.size();
            return servers.get(index);
        }
        catch (Throwable e) {
            Loggers.SRV_LOG.warn("[NACOS-DISTRO] distro mapper failed, return localhost: " + EnvUtil.getLocalAddress(), e);
            return EnvUtil.getLocalAddress();
        }
    }

    private int distroHash(String responsibleTag) {
        return Math.abs(responsibleTag.hashCode() % Integer.MAX_VALUE);
    }

    public void onEvent(MembersChangeEvent event) {
        List list = MemberUtil.simpleMembers((Collection)MemberUtil.selectTargetMembers((Collection)event.getMembers(), member -> NodeState.UP.equals((Object)member.getState()) || NodeState.SUSPICIOUS.equals((Object)member.getState())));
        Collections.sort(list);
        List<String> old = this.healthyList;
        this.healthyList = Collections.unmodifiableList(list);
        Loggers.SRV_LOG.info("[NACOS-DISTRO] healthy server list changed, old: {}, new: {}", old, this.healthyList);
    }

    public boolean ignoreExpireEvent() {
        return true;
    }
}

