/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.naming.core.HealthOperator;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationService;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationServiceProxy;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HealthOperatorV2Impl
implements HealthOperator {
    private final NamingMetadataManager metadataManager;
    private final ClientManager clientManager;
    private final ClientOperationService clientOperationService;

    public HealthOperatorV2Impl(NamingMetadataManager metadataManager, ClientManagerDelegate clientManager, ClientOperationServiceProxy clientOperationService) {
        this.metadataManager = metadataManager;
        this.clientManager = clientManager;
        this.clientOperationService = clientOperationService;
    }

    @Override
    public void updateHealthStatusForPersistentInstance(String namespace, String fullServiceName, String clusterName, String ip, int port, boolean healthy) throws NacosException {
        String clientId;
        Client client;
        String serviceName;
        String groupName = NamingUtils.getGroupName((String)fullServiceName);
        Service service = Service.newService(namespace, groupName, serviceName = NamingUtils.getServiceName((String)fullServiceName));
        Optional<ServiceMetadata> serviceMetadata = this.metadataManager.getServiceMetadata(service);
        if (!serviceMetadata.isPresent() || !serviceMetadata.get().getClusters().containsKey(clusterName)) {
            this.throwHealthCheckerException(fullServiceName, clusterName);
        }
        ClusterMetadata clusterMetadata = serviceMetadata.get().getClusters().get(clusterName);
        if (!HealthCheckType.NONE.name().equals(clusterMetadata.getHealthyCheckType())) {
            this.throwHealthCheckerException(fullServiceName, clusterName);
        }
        if (null == (client = this.clientManager.getClient(clientId = IpPortBasedClient.getClientId(ip + ":" + port, false)))) {
            return;
        }
        InstancePublishInfo oldInstance = client.getInstancePublishInfo(service);
        if (null == oldInstance) {
            return;
        }
        Instance newInstance = InstanceUtil.parseToApiInstance(service, oldInstance);
        newInstance.setHealthy(healthy);
        this.clientOperationService.registerInstance(service, newInstance, clientId);
    }

    private void throwHealthCheckerException(String fullServiceName, String clusterName) throws NacosException {
        String errorInfo = String.format("health check is still working, service: %s, cluster: %s", fullServiceName, clusterName);
        throw new NacosException(400, errorInfo);
    }
}

