/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.ServiceOperator;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ServiceOperatorV1Impl
implements ServiceOperator {
    private final ServiceManager serviceManager;
    private final DistroMapper distroMapper;

    public ServiceOperatorV1Impl(ServiceManager serviceManager, DistroMapper distroMapper) {
        this.serviceManager = serviceManager;
        this.distroMapper = distroMapper;
    }

    @Override
    public void create(String namespaceId, String serviceName, ServiceMetadata metadata) throws NacosException {
        if (this.serviceManager.getService(namespaceId, serviceName) != null) {
            throw new IllegalArgumentException("specified service already exists, serviceName : " + serviceName);
        }
        com.alibaba.nacos.naming.core.Service service = new com.alibaba.nacos.naming.core.Service(serviceName);
        service.setProtectThreshold(metadata.getProtectThreshold());
        service.setEnabled(true);
        service.setMetadata(metadata.getExtendData());
        service.setSelector(metadata.getSelector());
        service.setNamespaceId(namespaceId);
        service.setGroupName(NamingUtils.getGroupName((String)serviceName));
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        service.validate();
        this.serviceManager.addOrReplaceService(service);
    }

    @Override
    public void update(Service service, ServiceMetadata metadata) throws NacosException {
        String namespaceId = service.getNamespace();
        String serviceName = service.getGroupedServiceName();
        com.alibaba.nacos.naming.core.Service serviceV1 = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(serviceV1, namespaceId, serviceName);
        serviceV1.setProtectThreshold(metadata.getProtectThreshold());
        serviceV1.setSelector(metadata.getSelector());
        serviceV1.setMetadata(metadata.getExtendData());
        serviceV1.setLastModifiedMillis(System.currentTimeMillis());
        serviceV1.recalculateChecksum();
        serviceV1.validate();
        this.serviceManager.addOrReplaceService(serviceV1);
    }

    @Override
    public void delete(String namespaceId, String serviceName) throws NacosException {
        this.serviceManager.easyRemoveService(namespaceId, serviceName);
    }

    @Override
    public ObjectNode queryService(String namespaceId, String serviceName) throws NacosException {
        com.alibaba.nacos.naming.core.Service service = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(service, namespaceId, serviceName);
        ObjectNode res = JacksonUtils.createEmptyJsonNode();
        res.put("name", NamingUtils.getServiceName((String)serviceName));
        res.put("namespaceId", service.getNamespaceId());
        res.put("protectThreshold", service.getProtectThreshold());
        res.replace("metadata", JacksonUtils.transferToJsonNode((Object)service.getMetadata()));
        res.replace("selector", JacksonUtils.transferToJsonNode((Object)service.getSelector()));
        res.put("groupName", NamingUtils.getGroupName((String)serviceName));
        ArrayNode clusters = JacksonUtils.createEmptyArrayNode();
        for (Cluster cluster : service.getClusterMap().values()) {
            ObjectNode clusterJson = JacksonUtils.createEmptyJsonNode();
            clusterJson.put("name", cluster.getName());
            clusterJson.replace("healthChecker", JacksonUtils.transferToJsonNode((Object)cluster.getHealthChecker()));
            clusterJson.replace("metadata", JacksonUtils.transferToJsonNode((Object)cluster.getMetadata()));
            clusters.add((JsonNode)clusterJson);
        }
        res.replace("clusters", (JsonNode)clusters);
        return res;
    }

    @Override
    public Collection<String> listService(String namespaceId, String groupName, String selector) throws NacosException {
        Map<String, com.alibaba.nacos.naming.core.Service> serviceMap = this.serviceManager.chooseServiceMap(namespaceId);
        if (serviceMap == null || serviceMap.isEmpty()) {
            return Collections.emptyList();
        }
        serviceMap = ServiceUtil.selectServiceWithGroupName(serviceMap, groupName);
        serviceMap = ServiceUtil.selectServiceBySelector(serviceMap, selector);
        if (!"*".equals(groupName)) {
            serviceMap.entrySet().removeIf(entry -> !((String)entry.getKey()).startsWith(groupName + "@@"));
        }
        return serviceMap.keySet();
    }

    @Override
    public Collection<String> listAllNamespace() {
        return this.serviceManager.getAllNamespaces();
    }

    @Override
    public Collection<String> searchServiceName(String namespaceId, String expr, boolean responsibleOnly) throws NacosException {
        List<com.alibaba.nacos.naming.core.Service> services = this.serviceManager.searchServices(namespaceId, ".*" + expr + ".*");
        HashSet<String> result = new HashSet<String>();
        for (com.alibaba.nacos.naming.core.Service each : services) {
            if (responsibleOnly && !this.distroMapper.responsible(each.getName())) continue;
            result.add(NamingUtils.getServiceName((String)each.getName()));
        }
        return result;
    }
}

